% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clipr_available}
\alias{clipr_available}
\alias{dr_clipr}
\title{Is the system clipboard available?}
\usage{
clipr_available(...)

dr_clipr(...)
}
\arguments{
\item{\ldots}{Pass other options to \code{\link[=write_clip]{write_clip()}}. Generally only used to
pass the argument \code{allow_non_interactive_use = TRUE}.}
}
\value{
\code{clipr_available} returns a boolean value.

Prints an informative message to the console with
software and system configuration requirements if clipr is not available
(invisibly returns the same string)
}
\description{
Checks to see if the system clipboard is write-able/read-able. This may be
useful if you are developing a package that relies on clipr and need
to ensure that it will skip tests on machines (e.g. CRAN, Travis) where
the system clipboard may not be available.
}
\details{
If you are trying to call this in a non-interactive session, be sure to call
using \code{clipr_available(allow_non_interactive = TRUE)}, or by setting the
environment variable \code{CLIPBOARD_AVAILABLE=TRUE}
}
\examples{
\dontrun{
# When using testthat:
library(testthat)
skip_if_not(clipr_available())
}

}
