% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys-time.R
\name{sys_time_info}
\alias{sys_time_info}
\title{Info: sys-time}
\usage{
sys_time_info(x, zone)
}
\arguments{
\item{x}{\verb{[clock_sys_time]}

A sys-time.}

\item{zone}{\verb{[character]}

A valid time zone name.

Unlike most functions in clock, in \code{sys_time_info()} \code{zone} is vectorized
and is recycled against \code{x}.}
}
\value{
A data frame of low level information.
}
\description{
\code{sys_time_info()} retrieves a set of low-level information generally not
required for most date-time manipulations. It returns a data frame with the
following columns:
\itemize{
\item \code{begin}, \code{end}: Second precision sys-times specifying the range of the
current daylight saving time rule. The range is a half-open interval of
\verb{[begin, end)}.
\item \code{offset}: A second precision \code{duration} specifying the offset from UTC.
\item \code{dst}: A logical vector specifying if daylight saving time is currently
active.
\item \code{abbreviation}: The time zone abbreviation in use throughout this \code{begin}
to \code{end} range.
}
}
\details{
If there have never been any daylight saving time transitions, the minimum
supported year value is returned for \code{begin} (typically, a year value of
\code{-32767}).

If daylight saving time is no longer used in a time zone, the maximum
supported year value is returned for \code{end} (typically, a year value of
\code{32767}).

The \code{offset} is the bridge between sys-time and naive-time for the \code{zone}
being used. The relationship of the three values is:\preformatted{offset = naive_time - sys_time
}
}
\examples{
library(vctrs)

x <- year_month_day(2021, 03, 14, c(01, 03), c(59, 00), c(59, 00))
x <- as_naive_time(x)
x <- as_zoned_time(x, "America/New_York")

# x[1] is in EST, x[2] is in EDT
x

x_sys <- as_sys_time(x)

info <- sys_time_info(x_sys, zoned_time_zone(x))
info

# Convert `begin` and `end` to zoned-times to see the previous and
# next daylight saving time transitions
data_frame(
  x = x,
  begin = as_zoned_time(info$begin, zoned_time_zone(x)),
  end = as_zoned_time(info$end, zoned_time_zone(x))
)

# `end` can be used to iterate through daylight saving time transitions
# by repeatedly calling `sys_time_info()`
sys_time_info(info$end, zoned_time_zone(x))

# Multiple `zone`s can be supplied to look up daylight saving time
# information in different time zones
zones <- c("America/New_York", "America/Los_Angeles")

info2 <- sys_time_info(x_sys[1], zones)
info2

# The offset can be used to display the naive-time (i.e. the printed time)
# in both of those time zones
data_frame(
  zone = zones,
  naive_time = x_sys[1] + info2$offset
)
}
