% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posixt.R
\name{posixt-setters}
\alias{posixt-setters}
\alias{set_year.POSIXt}
\alias{set_month.POSIXt}
\alias{set_day.POSIXt}
\alias{set_hour.POSIXt}
\alias{set_minute.POSIXt}
\alias{set_second.POSIXt}
\title{Setters: date-time}
\usage{
\method{set_year}{POSIXt}(x, value, ..., invalid = NULL, nonexistent = NULL, ambiguous = x)

\method{set_month}{POSIXt}(x, value, ..., invalid = NULL, nonexistent = NULL, ambiguous = x)

\method{set_day}{POSIXt}(x, value, ..., invalid = NULL, nonexistent = NULL, ambiguous = x)

\method{set_hour}{POSIXt}(x, value, ..., invalid = NULL, nonexistent = NULL, ambiguous = x)

\method{set_minute}{POSIXt}(x, value, ..., invalid = NULL, nonexistent = NULL, ambiguous = x)

\method{set_second}{POSIXt}(x, value, ..., invalid = NULL, nonexistent = NULL, ambiguous = x)
}
\arguments{
\item{x}{\verb{[POSIXct / POSIXlt]}

A date-time vector.}

\item{value}{\verb{[integer / "last"]}

The value to set the component to.

For \code{set_day()}, this can also be \code{"last"} to set the day to the
last day of the month.}

\item{...}{These dots are for future extensions and must be empty.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}

\item{nonexistent}{\verb{[character / NULL]}

One of the following nonexistent time resolution strategies, allowed to be
either length 1, or the same length as the input:
\itemize{
\item \code{"roll-forward"}: The next valid instant in time.
\item \code{"roll-backward"}: The previous valid instant in time.
\item \code{"shift-forward"}: Shift the nonexistent time forward by the size of
the daylight saving time gap.
\item \verb{"shift-backward}: Shift the nonexistent time backward by the size of
the daylight saving time gap.
\item \code{"NA"}: Replace nonexistent times with \code{NA}.
\item \code{"error"}: Error on nonexistent times.
}

Using either \code{"roll-forward"} or \code{"roll-backward"} is generally
recommended over shifting, as these two strategies maintain the
\emph{relative ordering} between elements of the input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{nonexistent} must be supplied
and cannot be \code{NULL}. This is a convenient way to make production code
robust to nonexistent times.}

\item{ambiguous}{\verb{[character / zoned_time / POSIXct / list(2) / NULL]}

One of the following ambiguous time resolution strategies, allowed to be
either length 1, or the same length as the input:
\itemize{
\item \code{"earliest"}: Of the two possible times, choose the earliest one.
\item \code{"latest"}: Of the two possible times, choose the latest one.
\item \code{"NA"}: Replace ambiguous times with \code{NA}.
\item \code{"error"}: Error on ambiguous times.
}

Alternatively, \code{ambiguous} is allowed to be a zoned_time (or POSIXct) that
is either length 1, or the same length as the input. If an ambiguous time
is encountered, the zoned_time is consulted. If the zoned_time corresponds
to a naive_time that is also ambiguous \emph{and} uses the same daylight saving
time transition point as the original ambiguous time, then the offset of
the zoned_time is used to resolve the ambiguity. If the ambiguity cannot be
resolved by consulting the zoned_time, then this method falls back to
\code{NULL}.

Finally, \code{ambiguous} is allowed to be a list of size 2, where the first
element of the list is a zoned_time (as described above), and the second
element of the list is an ambiguous time resolution strategy to use when
the ambiguous time cannot be resolved by consulting the zoned_time.
Specifying a zoned_time on its own is identical to \verb{list(<zoned_time>, NULL)}.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{ambiguous} must be supplied and
cannot be \code{NULL}. Additionally, \code{ambiguous} cannot be specified as a
zoned_time on its own, as this implies \code{NULL} for ambiguous times that the
zoned_time cannot resolve. Instead, it must be specified as a list
alongside an ambiguous time resolution strategy as described above. This is
a convenient way to make production code robust to ambiguous times.}
}
\value{
\code{x} with the component set.
}
\description{
These are POSIXct/POSIXlt methods for the \link[=clock-setters]{setter generics}.
\itemize{
\item \code{set_year()} sets the year.
\item \code{set_month()} sets the month of the year. Valid values are in the range
of \verb{[1, 12]}.
\item \code{set_day()} sets the day of the month. Valid values are in the range
of \verb{[1, 31]}.
\item There are sub-daily setters for setting more precise components, up to
a precision of seconds.
}
}
\examples{
x <- as.POSIXct("2019-02-01", tz = "America/New_York")

# Set the day
set_day(x, 12:14)

# Set to the "last" day of the month
set_day(x, "last")

# You cannot set a date-time to an invalid date like you can with
# a year-month-day. Instead, the default strategy is to error.
try(set_day(x, 31))
set_day(as_year_month_day(x), 31)

# You can resolve these issues while setting the day by specifying
# an invalid date resolution strategy with `invalid`
set_day(x, 31, invalid = "previous")

y <- as.POSIXct("2020-03-08 01:30:00", tz = "America/New_York")

# Nonexistent and ambiguous times must be resolved immediately when
# working with R's native date-time types. An error is thrown by default.
try(set_hour(y, 2))
set_hour(y, 2, nonexistent = "roll-forward")
set_hour(y, 2, nonexistent = "roll-backward")
}
