% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{compute_rmse}
\alias{compute_rmse}
\title{Trajectory similarity: Root Mean Squared Error RMSE}
\usage{
compute_rmse(res_mat1, res_mat2, normalize = "none")
}
\arguments{
\item{res_mat1}{Trajectory matrix 1, first column must be time while others are states.}

\item{res_mat2}{Trajectory matrix 2, first column must be time while others are states.}

\item{normalize}{Normalization method, one of "none", "range", "sd".}
}
\value{
RMSE of the two trajectory, vector with length = number of input states.
}
\description{
RMSE is used to characterize how \emph{absolute} values of two trajectory
\eqn{\vec{X}(t), \vec{Y}(t)} agree with each other. There are
normalized and default versions:
}
\details{
Default (value scales with variable \eqn{i}):

\eqn{\mbox{RMSE}_i=\sqrt{\frac{\Sigma(X_i(t^j)-Y_i(t^j))^2}{N}}}

Normalized (value normalized by range for each variable \eqn{i}):

\eqn{\mbox{NRMSE}_i=\frac{\mbox{RMSE}}{\mbox{spread}}} (spread is customizable)

For normalization, spread is always computed ONLY from \code{res_mat1}. \code{res_mat2}
is normalized using spread computed from \code{mat1} to still retain the property
that RMSE allows comparing \emph{absolute} values of two trajectories.

In this case, normalization is used to prevent numerically large states from
dominating RMSE results, giving a more thorough comparison of trajectories.
}
\examples{
# Perfect agreement (zero error)
mat1 <- cbind(time = 1:3, state1 = c(1, 2, 3), state2 = c(4, 5, 6))
mat2 <- mat1
compute_rmse(mat1, mat2)

# Simple error case
#   state1 = sqrt(mean(c(0,0,0.5)^2)) = 0.29
#   state2 = sqrt(mean(c(0,0.2,0)^2)) = 0.12
mat3 <- cbind(time = 1:3, state1 = c(1, 2, 3.5), state2 = c(4, 5.2, 6))
compute_rmse(mat1, mat3)

# Normalized example (NRMSE = RMSE / spread)
#   state1 = state2 = 1/20 = 0.05
mat4 <- cbind(time = 1:3, state1 = c(10, 20, 30), state2 = c(40, 50, 60))
mat5 <- cbind(time = 1:3, state1 = c(11, 21, 31), state2 = c(41, 51, 61))
compute_rmse(mat4, mat5, "range")  # c(1/20, 1/20) = c(0.05, 0.05)
}
