/*
 * Decompiled with CFR 0.152.
 */
package ppe;

import nbl.utilj.GuiUtil;

public class ExceptionHandler {
    public static boolean useGui = true;

    public static void display(Throwable x) {
        if (useGui) {
            ExceptionHandler.gui(x);
        } else {
            ExceptionHandler.text(x);
        }
    }

    public static void text(Throwable x) {
        Throwable c = x.getCause();
        if (c != null && c.getMessage() != null && c.getStackTrace() != null) {
            ExceptionHandler.text(c);
        } else {
            StringBuilder s = new StringBuilder("* ExceptionHandler:\n");
            String mess = x.getMessage();
            String stack = ExceptionHandler.stackTraceToString(x.getStackTrace());
            if (mess != null) {
                s.append(mess + "\n");
            } else {
                s.append("null exception message\n");
            }
            if (stack != null) {
                s.append(stack + "\n");
            }
            System.err.println(s.toString());
        }
    }

    public static void gui(Throwable x) {
        Throwable c = x.getCause();
        if (c != null && c.getMessage() != null && c.getStackTrace() != null) {
            ExceptionHandler.gui(c);
        } else {
            GuiUtil.exceptionMessage((Throwable)x);
        }
    }

    public static String stackTraceToString(StackTraceElement[] trace) {
        if (trace == null) {
            return "NULL stack trace.";
        }
        String s = "";
        for (int i = 0; i < trace.length; ++i) {
            s = trace[i] != null ? s + trace[i].toString() + "\n" : s + "null trace element at [" + i + "]";
        }
        return s;
    }

    public static RuntimeException toRuntimeException(Throwable x) {
        Throwable cause = x.getCause();
        if (cause != null && cause.getStackTrace() != null && cause.getStackTrace().length > 0) {
            if (cause instanceof RuntimeException) {
                return (RuntimeException)cause;
            }
            RuntimeException rx = new RuntimeException(cause.getMessage());
            rx.setStackTrace(cause.getStackTrace());
            return rx;
        }
        RuntimeException rx = new RuntimeException(x.getMessage());
        rx.setStackTrace(x.getStackTrace());
        return rx;
    }
}

