/*
 * Decompiled with CFR 0.152.
 */
package ppe;

import java.lang.reflect.Constructor;
import ppe.ec2.Ec2Wrangler;
import ppe.ec2.NetworkSpec;
import ppe.ompi.OmpiSpec;

public abstract class Services {
    private static Class servicesClass;
    protected String networkID;
    protected Ec2Wrangler ec2w;
    protected NetworkSpec networkSpec;
    protected OmpiSpec ompiSpec;

    public Services(String networkID) {
        this.networkID = networkID;
    }

    public abstract void launch();

    public abstract String getStateTitle();

    public abstract boolean isRunning();

    public abstract boolean isPending();

    public abstract boolean notRunning();

    public abstract boolean inNilState();

    public void set(Ec2Wrangler ec2w, NetworkSpec networkSpec, OmpiSpec ompiSpec) {
        this.ec2w = ec2w;
        this.networkSpec = networkSpec;
        this.ompiSpec = ompiSpec;
    }

    public static void setServicesClass(Class servicesClass) {
        Services.servicesClass = servicesClass;
    }

    public static Services createServices(String networkID) {
        try {
            Constructor cons = servicesClass.getConstructor(String.class);
            Services s = (Services)cons.newInstance(networkID);
            return s;
        }
        catch (Exception xxx) {
            if (xxx.getCause() != null) {
                throw new RuntimeException(xxx.getCause());
            }
            throw new RuntimeException(xxx);
        }
    }
}

