/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.Region;
import com.norbl.cbp.ppe.AmiPPE;
import com.norbl.cbp.ppe.AwsClientConfigParams;
import com.norbl.cbp.ppe.ConstantsEc2;
import com.norbl.cbp.ppe.EbsVolumeWrangler;
import com.norbl.cbp.ppe.Ec2InstanceType;
import com.norbl.cbp.ppe.Ec2Wrangler;
import com.norbl.cbp.ppe.IncompleteNetworkSpecException;
import com.norbl.cbp.ppe.InstanceTableManager;
import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NetworkPinger;
import com.norbl.cbp.ppe.NetworkSpec;
import com.norbl.cbp.ppe.NetworkTableModel;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.ParamHtPPE;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.Services;
import com.norbl.cbp.ppe.gui.AboutGui;
import com.norbl.cbp.ppe.gui.ActionCommandNetworkManager;
import com.norbl.cbp.ppe.gui.EbsVolumeListFrame;
import com.norbl.cbp.ppe.gui.Ec2AuthorizationIDParams;
import com.norbl.cbp.ppe.gui.Ec2ParamEditor;
import com.norbl.cbp.ppe.gui.InProgressFrame;
import com.norbl.cbp.ppe.gui.MessageDialog;
import com.norbl.cbp.ppe.gui.NetworkManagerFrame;
import com.norbl.cbp.ppe.usermonitor.AuthorizationClient;
import com.norbl.cbp.ppe.usermonitor.CancelBillingMessage;
import com.norbl.util.ExceptionHandler;
import com.norbl.util.MissingParamsException;
import com.norbl.util.ParamHt;
import com.norbl.util.aws.S3Access;
import com.norbl.util.gui.GuiUtil;
import com.norbl.util.gui.SwingDefaults;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JFrame;

public abstract class PPEManager {
    public ParamHt paramHt;
    public static ParamsEc2 paramsEc2;
    public Ec2Wrangler ec2w;
    public AwsClientConfigParams awsClientConfigParams;
    public NetworkTableModel networkTableModel;
    public InstanceTableManager instanceTableManager;
    NiUpdater niUpdater;
    public List<Ec2InstanceType> instanceTypes;
    String amiGroupName;
    public List<AmiPPE> amis;
    public Region ec2Region;
    public List<AvailabilityZone> availabilityZones;
    public EbsVolumeWrangler ebsVolumeWrangler;
    private EbsVolumeListFrame ebsVolumeListFrame;
    JFrame networkManagerFrame;

    public PPEManager(String[] argv, String amiGroupName, Region ec2Region) throws Exception {
        this.paramHt = new ParamHtPPE(argv);
        paramsEc2 = new ParamsEc2(this.paramHt);
        this.amiGroupName = amiGroupName;
        this.ec2Region = ec2Region;
        this.awsClientConfigParams = new AwsClientConfigParams(this);
        NiM.init();
        this.networkTableModel = new NetworkTableModel();
        this.instanceTableManager = new InstanceTableManager(this.ebsVolumeWrangler);
        this.setupAWSWrangling();
    }

    public boolean setupAWSWrangling() throws MissingParamsException {
        if (!paramsEc2.hasRequiredEc2LaunchParams()) {
            return false;
        }
        this.ec2w = this.createWrangler();
        this.ec2w.ec2Client.setEndpoint(this.ec2Region.getEndpoint());
        this.availabilityZones = this.ec2w.ec2Client.describeAvailabilityZones().getAvailabilityZones();
        this.specifyServices();
        NiM.addStateChangeListener(this.networkTableModel);
        NiM.addStateChangeListener(this.instanceTableManager);
        this.startNetworkInfoUpdater();
        this.ebsVolumeWrangler = new EbsVolumeWrangler(this.ec2w.ec2Client);
        this.ebsVolumeWrangler.retrieveVolumeInfo();
        this.instanceTableManager.setEbsVolumeWrangler(this.ebsVolumeWrangler);
        try {
            this.instanceTypes = Ec2InstanceType.getInstanceTypes();
            this.amis = AmiPPE.retrieveAndInitAmiPPEs(new S3Access(), this.amiGroupName, this.ec2w.ec2Client);
            for (AmiPPE ami : this.amis) {
                ami.region = this.ec2Region;
            }
            return true;
        }
        catch (Exception xxx) {
            GuiUtil.warning(new String[]{"Failed to retrieve instance types or AMI descriptions from S3.", "This usually means that you are not connected to the internet", " ", xxx.toString()}, "Error");
            return false;
        }
    }

    private Ec2Wrangler createWrangler() throws MissingParamsException {
        ClientConfiguration cc = null;
        if (this.awsClientConfigParams != null && this.awsClientConfigParams.size() > 0) {
            cc = this.awsClientConfigParams.buildClientConfiguration();
        }
        return new Ec2Wrangler(paramsEc2, cc);
    }

    public void setNetworkManagerFrame(JFrame f) {
        this.networkManagerFrame = f;
    }

    public boolean goodToGo() {
        return paramsEc2.hasRequiredEc2LaunchParams() && this.ec2w != null;
    }

    boolean goodToGoShowWarning() {
        if (this.goodToGo()) {
            return true;
        }
        MessageDialog.showNotGoodToGoWarning(this.networkManagerFrame, this);
        return false;
    }

    protected abstract void specifyServices();

    protected abstract void initializeServices(NetworkSpec var1, Services var2) throws Exception;

    protected abstract NetworkSpec getFullySpecifiedNetworkSpec(String var1);

    protected abstract String getAboutAppTitle();

    protected abstract String getAboutAppVersion();

    public void updateParamsFromConfigFile() {
        try {
            if (!this.paramHt.reloadParams()) {
                GuiUtil.warning(new String[]{"There is no param file, so params cannot be update.", "Edit the ec2 params (Edit -> Ec2 parameters"}, "No param file");
            } else {
                paramsEc2 = new ParamsEc2(this.paramHt);
                if (paramsEc2.hasRequiredEc2LaunchParams()) {
                    if (this.ec2w != null && this.ec2w.ec2Client == null) {
                        this.ec2w.ec2Client.shutdown();
                    }
                    this.ec2w = this.createWrangler();
                }
            }
        }
        catch (Exception xx) {
            GuiUtil.exceptionMessage(xx);
        }
    }

    public NetworkTableModel getNetworkTableModel() {
        return this.networkTableModel;
    }

    public void updateParamsReBillingAuthorizationID(String ema) throws Exception {
        this.paramHt.put(ParamsEc2.ParamName.uid.toString(), ema);
        this.paramHt.saveAndReload(false);
        paramsEc2 = new ParamsEc2(this.paramHt);
    }

    public void doOp(ActionCommandNetworkManager ac) {
        new OpThread(ac).start();
    }

    public void createNetwork() throws Exception {
        if (!this.goodToGoShowWarning()) {
            return;
        }
        InProgressFrame.showInProgress();
        String networkName = Ec2Wrangler.chooseNetworkName(paramsEc2);
        final NetworkSpec networkSpec = this.getFullySpecifiedNetworkSpec(networkName);
        if (networkSpec == null) {
            return;
        }
        if (!networkSpec.isComplete()) {
            throw new IncompleteNetworkSpecException(networkSpec.listMissingParams());
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String networkID = PPEManager.this.ec2w.createNetwork(networkSpec, PPEManager.this.instanceTypes);
                    NetworkPinger pinger = new NetworkPinger(PPEManager.this.ec2w);
                    if (!pinger.pingNetwork(networkID)) {
                        GuiUtil.warning(new String[]{"There are NO usable instances."}, "No usable instances");
                        return;
                    }
                    NetworkInfo ni = NiM.getForID(networkID);
                    if (ni == null) {
                        throw new RuntimeException("NO  network info for ID=" + networkID);
                    }
                    Services s = ni.getServices();
                    PPEManager.this.initializeServices(networkSpec, s);
                    s.launch();
                    NiM.update(PPEManager.this.ec2w);
                }
                catch (Exception xxx) {
                    ExceptionHandler.gui(xxx);
                    GuiUtil.warning(new String[]{"The network may not have been configured."}, "Warning");
                }
            }
        }.start();
    }

    public void rebootInstances(String networkID) throws Exception {
        if (!this.goodToGoShowWarning()) {
            return;
        }
        NetworkInfo ni = NiM.getForID(networkID);
        if (ni == null) {
            return;
        }
        if (GuiUtil.answerIsYes(new String[]{"Reboot all instances in network", ni.getNetworkName() + " ?"}, "Reboot instances")) {
            this.ec2w.rebootInstances(ni);
            NiM.update(this.ec2w);
        }
    }

    public void terminateInstances(String networkID) {
        if (!this.goodToGoShowWarning()) {
            return;
        }
        NetworkInfo ni = NiM.getForID(networkID);
        if (ni == null) {
            return;
        }
        if (GuiUtil.answerIsYes(new String[]{"Terminate all instances in network", ni.getNetworkName() + " ?"}, "Terminate instances")) {
            this.ec2w.terminateInstances(ni);
            NiM.update(this.ec2w);
        }
    }

    public void updateNetworkInfo() {
        if (!this.goodToGoShowWarning()) {
            return;
        }
        NiM.update(this.ec2w);
    }

    public void exit() {
        System.exit(0);
    }

    public void showAbout() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AboutGui ag = new AboutGui();
                ag.setTitle(PPEManager.this.getAboutAppTitle());
                ag.setVersion(PPEManager.this.getAboutAppVersion());
                GuiUtil.centerOnScreen(ag);
                SwingDefaults.setIcon(ag);
                ag.setVisible(true);
            }
        });
    }

    public void authorizeInstanceBilling() {
        AuthorizationClient ac = new AuthorizationClient(this);
        ac.runAuthorizationDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancelInstanceBilling() {
        if (PPEManager.paramsEc2.uid != null) {
            S3Access s3a = null;
            try {
                if (!GuiUtil.answerIsYes(new String[]{" ", "Cancel instance billing for " + PPEManager.paramsEc2.uid + " ? ", " "}, "Cancel instance billing")) return;
                s3a = new S3Access();
                String oldUid = new String(PPEManager.paramsEc2.uid);
                CancelBillingMessage m = new CancelBillingMessage(PPEManager.paramsEc2.uid);
                s3a.putObject("norbl-inbox", m.key, m, false);
                this.updateParamsReBillingAuthorizationID(null);
                this.updateDisplayedBillingID();
                GuiUtil.info(new String[]{"  ", "Instance billing has been canceled for " + oldUid, "  "}, "Instance billing canceled");
                return;
            }
            catch (Exception xxx) {
                GuiUtil.exceptionMessage(xxx);
                return;
            }
            finally {
                if (s3a != null) {
                    s3a.close();
                }
            }
        } else {
            GuiUtil.warning(new String[]{"There is no user ID/email address in your config file.", "Please send email stating that you want to cancel ", "billing authorization to ", " ", "        billing@norbl.com", " ", "Please include your name and if possible the email address ", "you specified when you authorized billing."}, "User ID missing");
        }
    }

    public void editEc2Parameters() {
        try {
            final Ec2ParamEditor ed = new Ec2ParamEditor(this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ed.create();
                }
            });
            while (ed.isRunning) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ix) {}
            }
            Ec2AuthorizationIDParams eips = ed.getParams();
            if (eips != null && eips.paramsOk()) {
                eips.putInto(this.paramHt);
                this.saveParams();
                this.setupAWSWrangling();
            }
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessage(xxx);
        }
    }

    public void editAwsClientParameters() {
        this.awsClientConfigParams.editParams();
    }

    public void saveParams() throws Exception {
        this.paramHt.saveAndReload();
        paramsEc2 = new ParamsEc2(this.paramHt);
    }

    public void listEbsVolumes() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PPEManager.this.ebsVolumeWrangler == null) {
                    return;
                }
                if (PPEManager.this.ebsVolumeListFrame == null) {
                    PPEManager.this.ebsVolumeWrangler.retrieveVolumeInfo();
                    PPEManager.this.ebsVolumeListFrame = new EbsVolumeListFrame(PPEManager.this.ebsVolumeWrangler);
                    PPEManager.this.ebsVolumeListFrame.launch();
                } else {
                    PPEManager.this.ebsVolumeWrangler.retrieveVolumeInfo();
                    PPEManager.this.ebsVolumeListFrame.setVisible(true);
                }
                InProgressFrame.end();
            }
        });
    }

    public void updateEbsVolumeList() {
        if (this.ebsVolumeListFrame == null) {
            this.listEbsVolumes();
        } else {
            if (this.ebsVolumeWrangler == null) {
                return;
            }
            this.ebsVolumeWrangler.retrieveVolumeInfo();
        }
    }

    public String getBillingIDForDisplay() {
        if (PPEManager.paramsEc2.uid != null) {
            return PPEManager.paramsEc2.uid;
        }
        return "You have not authorized instance billing.";
    }

    public void updateDisplayedBillingID() {
        if (this.networkManagerFrame != null && this.networkManagerFrame instanceof NetworkManagerFrame) {
            ((NetworkManagerFrame)this.networkManagerFrame).setDisplayedBillingID(this.getBillingIDForDisplay());
        }
    }

    public void startNetworkInfoUpdater() {
        this.niUpdater = new NiUpdater();
        new Thread(this.niUpdater).start();
    }

    public void stopNetworkInfoUpdater() {
        this.niUpdater.keepUpdatingNetworkInfo = false;
    }

    class NiUpdater
    implements Runnable {
        boolean keepUpdatingNetworkInfo;

        NiUpdater() {
        }

        @Override
        public void run() {
            this.keepUpdatingNetworkInfo = true;
            while (this.keepUpdatingNetworkInfo) {
                NiM.update(PPEManager.this.ec2w);
                PPEManager.this.ebsVolumeWrangler.retrieveVolumeInfo();
                try {
                    Thread.sleep(ConstantsEc2.NETWORK_INFO_UPDATE_INTERVAL);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static enum Op {
        createNetwork("Create network"),
        updateNetworkInfo("Update network information"),
        editEc2Parameters("EC2 parameters"),
        editAwsClientParameters("AWS client parameters"),
        authorizeInstanceBilling("Authorize instance billing"),
        cancelInstanceBilling("Cancel authorization for instance billing"),
        showAbout("About"),
        exit("Exit"),
        rebootInstances("Reboot instances"),
        terminateInstances("Terminate instances"),
        listEbsVolumes("Show EBS volumes"),
        updateEbsVolumeList("Update list of EBS volumes");

        public String textMi;

        private Op(String textMI) {
            this.textMi = textMI;
        }
    }

    private class OpThread
    extends Thread {
        ActionCommandNetworkManager ac;

        OpThread(ActionCommandNetworkManager ac) {
            this.ac = ac;
        }

        @Override
        public void run() {
            try {
                Method m = this.ac.hasNetworkID() ? PPEManager.class.getMethod(this.ac.cmd, String.class) : PPEManager.class.getMethod(this.ac.cmd, new Class[0]);
                Class<?>[] paramTypes = m.getParameterTypes();
                Object[] params = paramTypes.length == 0 ? new Object[]{} : new Object[]{this.ac.networkID};
                m.invoke((Object)PPEManager.this, params);
            }
            catch (Exception xx) {
                GuiUtil.exceptionMessage(xx);
            }
        }
    }
}

