/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import com.norbl.cbp.ppe.usermonitor.UserDb;
import com.norbl.util.http.URIObj;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class PostAuthorizationHandler
implements HttpRequestHandler {
    UserDb userDb;
    private String billingCompleteHtml = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html><head><meta content=\"text/html; charset=ISO-8859-1\"http-equiv=\"Content-Type\"><title></title></head><body><br><br><br><h3 style=\"margin-left: 40px;\">Billing authorization complete</h3><div style=\"margin-left: 40px;\"><br><br><br>You can close this window.<br></div></body></html>";
    private String errorHtml = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html><head><meta content=\"text/html; charset=ISO-8859-1\"http-equiv=\"Content-Type\"><title></title></head><body><br><br><br><h3 style=\"margin-left: 40px;\">An error occurred during billingauthorization.<br></h3><div style=\"margin-left: 40px;\"><br><br><br>You may need to repeat the process.<br></div></body></html>";

    public PostAuthorizationHandler(UserDb userDb) {
        this.userDb = userDb;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        URIObj uio = new URIObj(request.getRequestLine().getUri());
        if (!uio.hasLocalPath()) {
            System.err.println("No local path in uri=\n" + request.getRequestLine().getUri());
            return;
        }
        if (!uio.localPathEls[0].equals("postauth")) {
            this.sendErrorPage(response);
            return;
        }
        String uid = uio.localPathEls[1];
        if (uid == null || uid.length() < 3) {
            this.sendErrorPage(response);
            return;
        }
        this.userDb.markAuthorized(uid, uio.getParam("settlementTokenID"), uio.getParam("creditSenderTokenID"), uio.getParam("creditInstrumentID"));
        response.setStatusCode(200);
        EntityTemplate body = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(outstream, "UTF-8");
                writer.write(PostAuthorizationHandler.this.billingCompleteHtml);
                writer.flush();
            }
        });
        body.setContentType("text/html; charset=UTF-8");
        response.setEntity((HttpEntity)body);
    }

    void sendErrorPage(HttpResponse response) {
        response.setStatusCode(200);
        EntityTemplate body = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(outstream, "UTF-8");
                writer.write("<html><body><h1>");
                writer.write("All done.");
                writer.write("</h1></body></html>");
                writer.flush();
            }
        });
        body.setContentType("text/html; charset=UTF-8");
        response.setEntity((HttpEntity)body);
    }
}

