/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import com.norbl.cbp.ppe.ParamHtPPE;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.usermonitor.MonitorHostname;
import com.norbl.cbp.ppe.usermonitor.PostAuthorizationHandler;
import com.norbl.cbp.ppe.usermonitor.UserDb;
import com.norbl.cbp.ppe.usermonitor.UserMonitorMessageHandler;
import com.norbl.cbp.ppe.usermonitor.UserStatus;
import com.norbl.util.ArgvUtil;
import com.norbl.util.ParamHt;
import com.norbl.util.aws.S3Access;
import com.norbl.util.aws.SDBAccess;
import com.norbl.util.http.SimpleHttpServer;
import java.net.ServerSocket;
import java.net.Socket;

public class UserMonitor {
    public static final String POST_AUTH_URI_FLAG = "postauth";
    int jPort;
    int hPort;
    ParamHt paramHt;
    ParamsEc2 paramEc2;
    UserDb userDb;
    UserStatus userStatus;
    S3Access s3Access;
    SDBAccess sdbAccess;
    String postAuthorizationUrl;
    MessageServer messageServer;
    public static boolean verbose;

    public UserMonitor(String[] argv) throws Exception {
        this.paramHt = new ParamHtPPE(argv);
        this.paramEc2 = new ParamsEc2(this.paramHt);
        this.sdbAccess = new SDBAccess(this.paramEc2);
        this.userDb = new UserDb(this.sdbAccess);
        this.s3Access = new S3Access(this.paramEc2);
        this.userStatus = new UserStatus(this.s3Access);
        verbose = ArgvUtil.getVal(argv, "verbose") != null;
        this.setupServerURL();
        String pj = (String)this.paramHt.get("jPort");
        this.jPort = pj != null ? Integer.parseInt(pj) : 16020;
        String ph = (String)this.paramHt.get("hPort");
        this.hPort = ph != null ? Integer.parseInt(ph) : 80;
        PostAuthorizationHandler postAuthorizationHandler = new PostAuthorizationHandler(this.userDb);
        SimpleHttpServer.ReqListenerThread httpReqThread = new SimpleHttpServer.ReqListenerThread(postAuthorizationHandler, this.hPort);
        httpReqThread.setDaemon(false);
        httpReqThread.start();
        this.messageServer = new MessageServer();
        Thread mt = new Thread(this.messageServer);
        mt.setDaemon(false);
        mt.start();
    }

    private void setupServerURL() throws Exception {
        String hostname = MonitorHostname.getThisHostsPublicName();
        MonitorHostname.setHostNameOnS3(this.s3Access, hostname);
        this.postAuthorizationUrl = "http://" + hostname;
    }

    public static void main(String[] argv) throws Exception {
        System.setProperty("org.apache.commons.logging.Log", "com.norbl.util.NearNilLog");
        UserMonitor um = new UserMonitor(argv);
    }

    class MessageServer
    implements Runnable {
        boolean keepRunning;

        MessageServer() {
        }

        @Override
        public void run() {
            try {
                this.keepRunning = true;
                ServerSocket serverSocket = new ServerSocket(UserMonitor.this.jPort);
                System.out.println("MessageServer listening on port " + UserMonitor.this.jPort);
                while (this.keepRunning) {
                    try {
                        Socket s = serverSocket.accept();
                        UserMonitorMessageHandler h = new UserMonitorMessageHandler(UserMonitor.this.paramEc2, UserMonitor.this.userDb, UserMonitor.this.userStatus, s, UserMonitor.this.postAuthorizationUrl);
                        new Thread(h).start();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception iox) {
                System.err.println("Terminal exception: " + iox);
                System.exit(0);
            }
        }
    }
}

