/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui;

import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.gui.Ec2AuthorizationIDParams;
import com.norbl.cbp.ppe.gui.Ec2ParamEditorFrame;
import com.norbl.util.AbstractParams;
import com.norbl.util.ParamHt;
import com.norbl.util.SysProp;
import com.norbl.util.gui.GuiUtil;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Ec2ParamEditor
implements ActionListener,
HyperlinkListener,
WindowStateListener {
    private String accountNumber;
    private String accessKeyID;
    private String secretAccessKey;
    private String rsaKeyName;
    private File rsaKeyPairFile;
    private PPEManager ppeManager;
    Ec2ParamEditorFrame edFrame;
    private Ec2AuthorizationIDParams eips;
    public boolean isRunning = true;
    String intro;
    String accountKeyText;
    String accountNumberText;
    String accessKeyNotes;
    String rsaNotes;

    public Ec2ParamEditor(PPEManager ppeManager) {
        this.ppeManager = ppeManager;
        ParamHt ht = ppeManager.paramHt;
        if (ht == null) {
            return;
        }
        this.accountNumber = (String)ht.get(ParamsEc2.ParamName.awsUserID.toString());
        this.accessKeyID = (String)ht.get(ParamsEc2.ParamName.awsAccessKey.toString());
        this.secretAccessKey = (String)ht.get(ParamsEc2.ParamName.awsSecretKey.toString());
        this.rsaKeyName = (String)ht.get(ParamsEc2.ParamName.keyName.toString());
        String rsaKeyPairPath = (String)ht.get(ParamsEc2.ParamName.rsaKeyPairFile.toString());
        if (rsaKeyPairPath != null) {
            this.rsaKeyPairFile = new File(rsaKeyPairPath);
        }
    }

    public void create() {
        this.edFrame = new Ec2ParamEditorFrame(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ec2ParamEditor.this.initText();
                Ec2ParamEditor.this.edFrame.create();
                Ec2ParamEditor.this.edFrame.addWindowStateListener(Ec2ParamEditor.this);
                GuiUtil.centerOnScreen(Ec2ParamEditor.this.edFrame);
                Ec2ParamEditor.this.initializeFields();
                Ec2ParamEditor.this.edFrame.setVisible(true);
            }
        });
    }

    public Ec2AuthorizationIDParams getParams() {
        return this.eips;
    }

    private Ec2AuthorizationIDParams recordParams() {
        this.eips = new Ec2AuthorizationIDParams();
        this.eips.accountNumber = this.accountNumber;
        this.eips.accessKeyID = this.accessKeyID;
        this.eips.secretAccessKey = this.secretAccessKey;
        this.eips.rsaKeyName = this.rsaKeyName;
        this.eips.rsaKeyPairFile = this.rsaKeyPairFile;
        return this.eips;
    }

    void initializeFields() {
        this.edFrame.setAccountNumber(this.accountNumber);
        this.edFrame.setAccessKeyID(this.accessKeyID);
        this.edFrame.setSecretKey(this.secretAccessKey);
        this.edFrame.setRsaKeyName(this.rsaKeyName);
        if (this.rsaKeyPairFile != null) {
            this.edFrame.setRsaKeyPairFile(this.rsaKeyPairFile.getPath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        EntryControl ec = EntryControl.valueOf(com);
        switch (ec) {
            case chooseFile: {
                this.chooseFile();
                break;
            }
            case cancel: {
                this.edFrame.dispose();
                this.eips = null;
                this.isRunning = false;
                break;
            }
            case ok: {
                if (this.checkParams()) {
                    this.recordParams();
                    this.isRunning = false;
                    this.edFrame.dispose();
                    break;
                }
                if (!GuiUtil.answerIsYes(new String[]{"There were errors in the params; exit without saving changes?"}, "Quit now?")) break;
                this.eips = null;
                this.isRunning = false;
                break;
            }
            default: {
                this.handleParam(ec);
            }
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        int s = e.getNewState();
        if (s == 201 || s == 202) {
            this.isRunning = false;
        }
    }

    private boolean handleParam(EntryControl ec) {
        try {
            switch (ec) {
                case accountNumber: {
                    this.parseAccountNumber();
                    break;
                }
                case accessKeyID: {
                    this.accessKeyID = this.edFrame.getAccessKeyID().trim();
                    this.checkString(this.accessKeyID, "Access Key ID");
                    break;
                }
                case secretAccessKey: {
                    this.secretAccessKey = this.edFrame.getSecretKey().trim();
                    break;
                }
                case rsaKeyName: {
                    this.rsaKeyName = this.edFrame.getRsaKeyName().trim();
                    this.checkString(this.rsaKeyName, "RSA key name");
                    break;
                }
                case rsaKeyPairFile: {
                    String pn = this.edFrame.getRsaKeyPairFile().trim();
                    File f = new File(pn);
                    if (AbstractParams.checkForReadFileAccess(f)) {
                        this.rsaKeyPairFile = f;
                        break;
                    }
                    this.rsaKeyPairFile = null;
                    return false;
                }
            }
            return true;
        }
        catch (BadParamException x) {
            GuiUtil.warning(x.m, x.title);
            return false;
        }
    }

    private void checkString(String s, String name) throws BadParamException {
        if (s == null || s.length() < 1) {
            throw new BadParamException(new String[]{name + " is blank."}, "Param error");
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                URL url = e.getURL();
                Desktop.getDesktop().browse(URI.create(url.toString()));
            }
        }
        catch (Exception xx) {
            GuiUtil.exceptionMessage(xx);
        }
    }

    void parseAccountNumber() throws BadParamException {
        String s = this.edFrame.getAccountNumber().trim();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isDigit(c)) continue;
            b.append(c);
        }
        String ns = b.toString();
        if (ns.length() != 12) {
            throw new BadParamException(new String[]{s, "is not a valid account number. An account number must have twelve digits."}, "Invalid account number");
        }
        this.accountNumber = ns;
    }

    void chooseFile() {
        File f = GuiUtil.getFile("Specify the RSA keypair file", new File(SysProp.user_home.getVal()));
        if (f == null) {
            return;
        }
        if (f.exists() && !f.isDirectory()) {
            this.edFrame.setRsaKeyPairFile(f.getPath());
        } else {
            GuiUtil.warning(new String[]{f.getPath() + " does not exist or is a directory."}, "Improper file");
        }
    }

    boolean checkParams() {
        int nBad = 0;
        for (EntryControl ec : EntryControl.values()) {
            if (this.handleParam(ec)) continue;
            ++nBad;
        }
        return nBad == 0;
    }

    void initText() {
        this.intro = "<html><body><p>Enter or modify Ec2 parameters. These parameters are <i>required</i> for launching and managing Ec2 instances.</p><p>These parameters will be stored in  <tt>" + ParamHt.getDefaultConfigFilePath(this.ppeManager.paramHt.configFilenameDefault) + "</tt>. " + "If you prefer, you can edit this file directly." + "<p>" + "Note that this file will contain your AWS 'Secret Key' " + "<i>en claire</i>, so it is important that it be secure. " + "It will be created with read and write permisson granted to " + "the owner only (0600 on unix systems) and we recommend that you " + "maintain restricted access to this file." + "</body></html>";
        this.accountKeyText = "<html><body><p> The following three parameters can be obtained from your Amazon account <a href=\"https://aws-portal.amazon.com/gp/aws/developer/account/index.html?ie=UTF8&amp;action=access-key\">Security Credentials</a> page.</body></html>";
        this.accountNumberText = "This is a twelve digit number located near the top right of the 'Security Credentials' page\n(among other places). You can enter it with or without the embedded dashes.";
        this.accessKeyNotes = "The 'Access Key ID' and 'Secret Access Key' are in the  'Access Credentials' section of the\n'Access Keys' tab on your Amazon Security Credentials page.";
        this.rsaNotes = "<html><p>Your key name is displayed in <a href=\"https://console.aws.amazon.com/ec2/home\">AWS Management Console</a> (EC2 tab, NETWORK & SECURITY -> Key Pair).</p><p>Ec2 instances are accessed using an RSA keypair, which is created and registered using the EC2/Keypair page of the AWS Management Console. (Note that Amazon does not keep a copy of the private key, only the public key.) The 'RSA key name' is the name you assigned to this keypair. The 'RSA keypair file' is the file that contains the keypair (downloaded from Amazon when you created the keypair).</p></html>";
    }

    class BadParamException
    extends Exception {
        String[] m;
        String title;

        public BadParamException(String[] m, String title) {
            this.m = m;
            this.title = title;
        }
    }

    public static enum EntryControl {
        accountNumber,
        accessKeyID,
        secretAccessKey,
        rsaKeyName,
        rsaKeyPairFile,
        chooseFile,
        cancel,
        ok;

    }
}

