/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.ssh;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import com.norbl.cbp.ppe.PPEApp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SshExec {
    protected Connection connection;

    public SshExec(Connection connection) throws IOException {
        this.connection = connection;
    }

    public String execRead(String cmd, long maxWait) throws IOException {
        ExecReader er = new ExecReader(cmd, maxWait);
        er.doEr();
        try {
            if (er.stdout.s != null) {
                return er.stdout.s;
            }
            return er.stderr.s;
        }
        catch (Exception xxx) {
            PPEApp.verbose(xxx);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execNoRead(String cmd) throws IOException {
        Session s = null;
        s = this.connection.openSession();
        s.execCommand(cmd);
    }

    public void exec(String cmd, long maxWait) throws IOException {
        ExecThread et = new ExecThread(this.connection.openSession(), cmd);
        new Thread(et).start();
        long tN = System.currentTimeMillis() + maxWait;
        while (!et.done && System.currentTimeMillis() < tN) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ix) {}
        }
        if (!et.done) {
            PPEApp.verbose("Timed out execing " + cmd);
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public boolean fileExists(String path, long maxWait) throws IOException {
        String r = this.execRead("[ -f " + path + "  ] && echo TRUE || echo FALSE", maxWait);
        return r.trim().equals("TRUE");
    }

    class ReadThread
    implements Runnable {
        InputStream ins;
        String s;
        Exception iox;
        boolean done;

        ReadThread(InputStream ins) {
            this.ins = ins;
            this.done = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufR br = null;
            try {
                br = new BufR(this.ins);
                this.s = br.readCompletely();
                this.done = true;
            }
            catch (IOException iox) {
                this.iox = iox;
                this.done = true;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception xxx) {
                    PPEApp.verbose(xxx);
                }
            }
        }
    }

    class ExecReader {
        String cmd;
        Session s;
        long maxWait;
        ReadThread stdout;
        ReadThread stderr;

        ExecReader(String cmd, long maxWait) throws IOException {
            this.cmd = cmd;
            this.maxWait = maxWait;
            this.s = SshExec.this.connection.openSession();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doEr() throws IOException {
            try {
                this.stdout = new ReadThread(this.s.getStdout());
                this.stderr = new ReadThread(this.s.getStderr());
                new Thread(this.stdout).start();
                new Thread(this.stderr).start();
                this.s.execCommand(this.cmd);
                long tN = System.currentTimeMillis() + this.maxWait;
                while (!this.stdout.done && !this.stderr.done && System.currentTimeMillis() < tN) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.stdout.done && !this.stderr.done) {
                    PPEApp.verbose("Timed out exec-ing " + this.cmd);
                }
            }
            finally {
                if (this.s != null) {
                    this.s.close();
                }
            }
        }

        public String getRead() {
            if (this.stdout.s != null) {
                return this.stdout.s;
            }
            return this.stderr.s;
        }
    }

    class BufR {
        InputStream ins;
        InputStreamReader r;
        BufferedReader b;

        BufR(InputStream ins) {
            this.ins = ins;
            this.r = new InputStreamReader(ins);
            this.b = new BufferedReader(this.r);
        }

        String readCompletely() throws IOException {
            String l;
            StringBuilder s = new StringBuilder();
            while ((l = this.b.readLine()) != null) {
                s.append(l + "\n");
            }
            return s.toString();
        }

        void close() throws IOException {
            this.b.close();
            this.r.close();
            this.ins.close();
        }
    }

    class ExecThread
    implements Runnable {
        Session s;
        String cmd;
        boolean done;

        ExecThread(Session s, String cmd) {
            this.s = s;
            this.cmd = cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.done = false;
                this.s.execCommand(this.cmd);
            }
            catch (Exception xxx) {
                System.out.println("ExecThread cmd=" + this.cmd + " -> " + xxx);
            }
            finally {
                this.done = true;
                if (this.s != null) {
                    this.s.close();
                }
            }
        }
    }
}

