/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.Item;
import com.norbl.cbp.ppe.AmiPPE;
import com.norbl.cbp.ppe.ParamHtPPE;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.UtilApps;
import com.norbl.cbp.ppe.usermonitor.Message;
import com.norbl.cbp.ppe.usermonitor.MonitorHostname;
import com.norbl.cbp.ppe.usermonitor.ReadWriteConnection;
import com.norbl.cbp.ppe.usermonitor.UserDb;
import com.norbl.cbp.ppe.usermonitor.UserMonitorClientFrame;
import com.norbl.util.TimeUtil;
import com.norbl.util.aws.S3Access;
import com.norbl.util.aws.SDBAccess;
import com.norbl.util.gui.GuiUtil;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class UserMonitorClient {
    ParamHtPPE paramHt;
    ParamsEc2 paramsEc2;
    AmazonEC2Client ec2Client;
    AmazonS3Client s3Client;
    S3Access s3a;
    SDBAccess sdba;
    String monitorHostName;
    UserTableModel userTableModel;
    UserMonitorClientFrame frame;
    UserDb.El[] els = new UserDb.El[]{UserDb.El.uid, UserDb.El.status, UserDb.El.status_time, UserDb.El.n_instance_hours_unbilled, UserDb.El.n_instance_hours_billed};

    public UserMonitorClient() throws Exception {
        this.ec2Client = UtilApps.getEc2ClientNBL();
        this.s3Client = UtilApps.getS3ClientNBL();
        this.s3a = new S3Access(this.s3Client);
        this.sdba = UtilApps.getSDBAccess();
        this.monitorHostName = MonitorHostname.getHostNameFromS3();
        this.userTableModel = new UserTableModel();
        new Thread(new AccountUpdater()).start();
    }

    public static void main(String[] argv) throws Exception {
        UserMonitorClient umc = new UserMonitorClient();
        umc.launchGui();
    }

    public void launchGui() throws Exception {
        this.frame = new UserMonitorClientFrame(this);
        this.frame.launch();
        new Thread(new Pinger()).start();
    }

    public List<AmiPPE> getAmiData() {
        ArrayList<AmiPPE> amis = new ArrayList<AmiPPE>();
        for (String gn : new String[]{"ppe-runjrun-ami-zc", "ppe-cloudrmpi-ami-zc"}) {
            amis.addAll(AmiPPE.retrieveAndInitAmiPPEs(this.s3a, gn, this.ec2Client));
        }
        return amis;
    }

    public List<Item> getUserAccounts() {
        return this.sdba.getAll("ppe_user_db").getItems();
    }

    class Pinger
    implements Runnable {
        Pinger() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        Socket socket = new Socket(UserMonitorClient.this.monitorHostName, 16020);
                        ReadWriteConnection con = new ReadWriteConnection(socket, ReadWriteConnection.HostType.client);
                        Message.TestMessage m = new Message.TestMessage(TimeUtil.toDateTimeString(System.currentTimeMillis()));
                        con.writeMessage(m);
                        Message r = (Message)con.readMessage();
                        if (UserMonitorClient.this.frame != null) {
                            UserMonitorClient.this.frame.setTime(r.toString());
                        }
                        try {
                            Thread.sleep(10000L);
                            continue block4;
                        }
                        catch (InterruptedException ix) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception xxx) {
                    GuiUtil.exceptionMessage(xxx);
                    return;
                }
            }
        }
    }

    class AccountUpdater
    implements Runnable {
        AccountUpdater() {
        }

        @Override
        public void run() {
            while (true) {
                List<Item> uas = UserMonitorClient.this.getUserAccounts();
                UserMonitorClient.this.userTableModel.setUserAcounts(uas);
                UserMonitorClient.this.userTableModel.fireTableDataChanged();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    class UserTableModel
    extends AbstractTableModel {
        List<Item> uas;

        UserTableModel() {
        }

        void setUserAcounts(List<Item> uas) {
            this.uas = uas;
        }

        @Override
        public int getColumnCount() {
            return UserMonitorClient.this.els.length;
        }

        @Override
        public int getRowCount() {
            if (this.uas != null) {
                return this.uas.size();
            }
            return 0;
        }

        @Override
        public String getColumnName(int column) {
            return UserMonitorClient.this.els[column].toString();
        }

        @Override
        public Object getValueAt(int iRow, int iCol) {
            UserDb.El el;
            if (this.uas == null) {
                return null;
            }
            if (iRow >= this.uas.size()) {
                return null;
            }
            Item it = this.uas.get(iRow);
            String val = this.getVal(it, el = UserMonitorClient.this.els[iCol]);
            if (val == null) {
                return null;
            }
            if (el.equals((Object)UserDb.El.status_time)) {
                return this.toTime(val);
            }
            return val;
        }

        private String getVal(Item it, UserDb.El el) {
            String elName = el.toString();
            List ats = it.getAttributes();
            for (Attribute at : ats) {
                if (!at.getName().equals(elName)) continue;
                return at.getValue();
            }
            return null;
        }

        private String toTime(String t) {
            long val = Long.parseLong(t);
            return TimeUtil.toDateTimeString(val);
        }
    }
}

