/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.CloseStatusFilter;
import com.amazonaws.services.simpleworkflow.model.ExecutionTimeFilter;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.TagFilter;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionFilter;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListClosedWorkflowExecutionsRequestMarshaller
implements Marshaller<Request<ListClosedWorkflowExecutionsRequest>, ListClosedWorkflowExecutionsRequest> {
    @Override
    public Request<ListClosedWorkflowExecutionsRequest> marshall(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) {
        if (listClosedWorkflowExecutionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListClosedWorkflowExecutionsRequest> request = new DefaultRequest<ListClosedWorkflowExecutionsRequest>(listClosedWorkflowExecutionsRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.ListClosedWorkflowExecutions";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            TagFilter tagFilterTagFilter;
            WorkflowTypeFilter workflowTypeFilterTypeFilter;
            CloseStatusFilter closeStatusFilterCloseStatusFilter;
            WorkflowExecutionFilter workflowExecutionFilterExecutionFilter;
            ExecutionTimeFilter executionTimeFilterCloseTimeFilter;
            ExecutionTimeFilter executionTimeFilterStartTimeFilter;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listClosedWorkflowExecutionsRequest.getDomain() != null) {
                jsonWriter.key("domain").value(listClosedWorkflowExecutionsRequest.getDomain());
            }
            if (listClosedWorkflowExecutionsRequest != null && (executionTimeFilterStartTimeFilter = listClosedWorkflowExecutionsRequest.getStartTimeFilter()) != null) {
                jsonWriter.key("startTimeFilter").object();
                if (executionTimeFilterStartTimeFilter.getOldestDate() != null) {
                    jsonWriter.key("oldestDate").value(executionTimeFilterStartTimeFilter.getOldestDate());
                }
                if (executionTimeFilterStartTimeFilter.getLatestDate() != null) {
                    jsonWriter.key("latestDate").value(executionTimeFilterStartTimeFilter.getLatestDate());
                }
                jsonWriter.endObject();
            }
            if (listClosedWorkflowExecutionsRequest != null && (executionTimeFilterCloseTimeFilter = listClosedWorkflowExecutionsRequest.getCloseTimeFilter()) != null) {
                jsonWriter.key("closeTimeFilter").object();
                if (executionTimeFilterCloseTimeFilter.getOldestDate() != null) {
                    jsonWriter.key("oldestDate").value(executionTimeFilterCloseTimeFilter.getOldestDate());
                }
                if (executionTimeFilterCloseTimeFilter.getLatestDate() != null) {
                    jsonWriter.key("latestDate").value(executionTimeFilterCloseTimeFilter.getLatestDate());
                }
                jsonWriter.endObject();
            }
            if (listClosedWorkflowExecutionsRequest != null && (workflowExecutionFilterExecutionFilter = listClosedWorkflowExecutionsRequest.getExecutionFilter()) != null) {
                jsonWriter.key("executionFilter").object();
                if (workflowExecutionFilterExecutionFilter.getWorkflowId() != null) {
                    jsonWriter.key("workflowId").value(workflowExecutionFilterExecutionFilter.getWorkflowId());
                }
                jsonWriter.endObject();
            }
            if (listClosedWorkflowExecutionsRequest != null && (closeStatusFilterCloseStatusFilter = listClosedWorkflowExecutionsRequest.getCloseStatusFilter()) != null) {
                jsonWriter.key("closeStatusFilter").object();
                if (closeStatusFilterCloseStatusFilter.getStatus() != null) {
                    jsonWriter.key("status").value(closeStatusFilterCloseStatusFilter.getStatus());
                }
                jsonWriter.endObject();
            }
            if (listClosedWorkflowExecutionsRequest != null && (workflowTypeFilterTypeFilter = listClosedWorkflowExecutionsRequest.getTypeFilter()) != null) {
                jsonWriter.key("typeFilter").object();
                if (workflowTypeFilterTypeFilter.getName() != null) {
                    jsonWriter.key("name").value(workflowTypeFilterTypeFilter.getName());
                }
                if (workflowTypeFilterTypeFilter.getVersion() != null) {
                    jsonWriter.key("version").value(workflowTypeFilterTypeFilter.getVersion());
                }
                jsonWriter.endObject();
            }
            if (listClosedWorkflowExecutionsRequest != null && (tagFilterTagFilter = listClosedWorkflowExecutionsRequest.getTagFilter()) != null) {
                jsonWriter.key("tagFilter").object();
                if (tagFilterTagFilter.getTag() != null) {
                    jsonWriter.key("tag").value(tagFilterTagFilter.getTag());
                }
                jsonWriter.endObject();
            }
            if (listClosedWorkflowExecutionsRequest.getNextPageToken() != null) {
                jsonWriter.key("nextPageToken").value(listClosedWorkflowExecutionsRequest.getNextPageToken());
            }
            if (listClosedWorkflowExecutionsRequest.getMaximumPageSize() != null) {
                jsonWriter.key("maximumPageSize").value(listClosedWorkflowExecutionsRequest.getMaximumPageSize());
            }
            if (listClosedWorkflowExecutionsRequest.isReverseOrder() != null) {
                jsonWriter.key("reverseOrder").value(listClosedWorkflowExecutionsRequest.isReverseOrder());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

