/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyInstanceAttributeRequestMarshaller
implements Marshaller<Request<ModifyInstanceAttributeRequest>, ModifyInstanceAttributeRequest> {
    @Override
    public Request<ModifyInstanceAttributeRequest> marshall(ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) {
        if (modifyInstanceAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyInstanceAttributeRequest> request = new DefaultRequest<ModifyInstanceAttributeRequest>(modifyInstanceAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyInstanceAttribute");
        request.addParameter("Version", "2012-03-01");
        if (modifyInstanceAttributeRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(modifyInstanceAttributeRequest.getInstanceId()));
        }
        if (modifyInstanceAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifyInstanceAttributeRequest.getAttribute()));
        }
        if (modifyInstanceAttributeRequest.getValue() != null) {
            request.addParameter("Value", StringUtils.fromString(modifyInstanceAttributeRequest.getValue()));
        }
        List<InstanceBlockDeviceMappingSpecification> blockDeviceMappingsList = modifyInstanceAttributeRequest.getBlockDeviceMappings();
        int blockDeviceMappingsListIndex = 1;
        for (InstanceBlockDeviceMappingSpecification blockDeviceMappingsListValue : blockDeviceMappingsList) {
            InstanceBlockDeviceMappingSpecification instanceBlockDeviceMappingSpecificationMember = blockDeviceMappingsListValue;
            if (instanceBlockDeviceMappingSpecificationMember != null) {
                EbsInstanceBlockDeviceSpecification ebsInstanceBlockDeviceSpecificationEbs;
                if (instanceBlockDeviceMappingSpecificationMember.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(instanceBlockDeviceMappingSpecificationMember.getDeviceName()));
                }
                if ((ebsInstanceBlockDeviceSpecificationEbs = instanceBlockDeviceMappingSpecificationMember.getEbs()) != null) {
                    if (ebsInstanceBlockDeviceSpecificationEbs.getVolumeId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeId", StringUtils.fromString(ebsInstanceBlockDeviceSpecificationEbs.getVolumeId()));
                    }
                    if (ebsInstanceBlockDeviceSpecificationEbs.isDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebsInstanceBlockDeviceSpecificationEbs.isDeleteOnTermination()));
                    }
                }
                if (instanceBlockDeviceMappingSpecificationMember.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(instanceBlockDeviceMappingSpecificationMember.getVirtualName()));
                }
                if (instanceBlockDeviceMappingSpecificationMember.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(instanceBlockDeviceMappingSpecificationMember.getNoDevice()));
                }
            }
            ++blockDeviceMappingsListIndex;
        }
        if (modifyInstanceAttributeRequest.isSourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.isSourceDestCheck()));
        }
        if (modifyInstanceAttributeRequest.isDisableApiTermination() != null) {
            request.addParameter("DisableApiTermination.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.isDisableApiTermination()));
        }
        if (modifyInstanceAttributeRequest.getInstanceType() != null) {
            request.addParameter("InstanceType.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getInstanceType()));
        }
        if (modifyInstanceAttributeRequest.getKernel() != null) {
            request.addParameter("Kernel.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getKernel()));
        }
        if (modifyInstanceAttributeRequest.getRamdisk() != null) {
            request.addParameter("Ramdisk.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getRamdisk()));
        }
        if (modifyInstanceAttributeRequest.getUserData() != null) {
            request.addParameter("UserData.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getUserData()));
        }
        if (modifyInstanceAttributeRequest.getInstanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getInstanceInitiatedShutdownBehavior()));
        }
        List<String> groupsList = modifyInstanceAttributeRequest.getGroups();
        int groupsListIndex = 1;
        for (String groupsListValue : groupsList) {
            if (groupsListValue != null) {
                request.addParameter("GroupId." + groupsListIndex, StringUtils.fromString(groupsListValue));
            }
            ++groupsListIndex;
        }
        return request;
    }
}

