/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

abstract class TIterator {
    protected final THash _hash;
    protected int _expectedSize;
    protected int _index;

    public TIterator(THash hash) {
        this._hash = hash;
        this._expectedSize = this._hash.size();
        this._index = this._hash.capacity();
    }

    public boolean hasNext() {
        return this.nextIndex() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        float auto_compation_factor = this._hash._autoCompactionFactor;
        try {
            this._hash._autoCompactionFactor = 0.0f;
            this._hash.removeAt(this._index);
        }
        finally {
            this._hash._autoCompactionFactor = auto_compation_factor;
        }
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }

    protected abstract int nextIndex();
}

