% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{club}
\alias{club}
\title{Classify observations.}
\usage{
club(
  f,
  data,
  imprecision,
  nreps,
  normalise_cols,
  reorder_obs,
  display_progress
)
}
\arguments{
\item{f}{a formula.}

\item{data}{a data.frame.}

\item{imprecision}{a number indicting the margin of imprecision allowed in classification.}

\item{nreps}{the number of replicates to use in the randomisation test.}

\item{normalise_cols}{a boolean indicating whether to normalise matrix columns.}

\item{reorder_obs}{a string indicating the method for reordering observations to calculate c-values.}

\item{display_progress}{a boolean indictaing whether a progress bar should be displayed.}
}
\value{
an object of class "clubprofit" is a list containing the folllowing
components:
\describe{
  \item{prediction}{a character vector of predicted classifications.}
  \item{accuracy}{a character vector indicating whether each classification
  is "correct", "incorrect", or "ambiguous".}
  \item{pcc}{the percentage of correct classifications.}
  \item{cval}{the chance of randomly reordered data producing a PCC >= the
  observed PCC.}
  \item{pcc_replicates}{a vector of PCCs generated from randomly reordered
  data used to calculate \code{cval}.}
  \item{call}{the matched call.}
  }
}
\description{
\code{club()} is used to classify obervations using binary procrustes
rotation.
}
\examples{
mod <- club(rate ~ dose, data = caffeine)
}
