\name{expressionPlot}
\alias{expressionPlot}
\title{
Generate a profile plot for the data partitioned by cluster membership.
}
\description{
This function uses the \code{\link{lattice}} function \code{\link{xyplot}} to generate a profile plot of the data values grouped by cluster in a multi-panel plot. The function
takes as input the original data.frame() and a valid \code{"consmatrix"} class object (see \code{\link{consmatrix-class}}) by which to segregate the data.
}
\usage{
expressionPlot(x,cm);
}

\arguments{
	\item{x}{
		the original data.frame() object used in the clustering.
	}
	\item{cm}{
		a valid \code{"consmatrix"} class object generated by the \code{\link{cluscomp}} function.
	}
}

\references{
Merged consensus clustering to assess and improve class discovery with microarray data. Simpson TI, Armstrong JD and Jarman AP. BMC Bioinformatics 2010, 11:590.
}

\author{
Dr. T. Ian Simpson
\email{ian.simpson@ed.ac.uk}
}

\seealso{
\code{\link{consmatrix-class}}
}
\examples{
#load up the data set
data(sim_profile);

#load up an example cluscomp result with this data
data('testcmr');

#plot the expression profiles
expressionPlot(sim_profile,testcmr$e1_kmeans_k4);

}