% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosenbclust.R
\name{choosenbclust}
\alias{choosenbclust}
\title{Tune the number of clusters according to the partition instability}
\usage{
choosenbclust(output, grid = 2:5, graph = TRUE, verbose = TRUE, nnodes = NULL)
}
\arguments{
\item{output}{an output from the clusterMI function}

\item{grid}{a vector indicating the grid of values tested for nb.clust. By default 2:5}

\item{graph}{a boolean indicating if a graphic is plotted}

\item{verbose}{if TRUE, choosenbclust will print messages on console}

\item{nnodes}{number of CPU cores for parallel computing. By default, the value used in the call to the clusterMI function}
}
\value{
a list of two objects
 \item{nb.clust}{the number of clusters in \code{grid} minimizing the instability}
 \item{crit}{a vector indicating the instability for each value in the grid}
}
\description{
\code{choosenbclust} reports the cluster instability according to the number of clusters chosen.
}
\details{
The \code{choosenbclust} function browses a grid of values for the number of clusters and for each one imputes the data and computes the instability.
}
\examples{
\dontshow{if (.Platform$OS.type=="windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(wine, package = "clusterMI")

require(parallel)
set.seed(123456)
ref <- wine$cult
nb.clust <- 3
wine.na <- wine
wine.na$cult <- NULL
wine.na <- prodna(wine.na)

# imputation
res.imp <- imputedata(data.na=wine.na, nb.clust = nb.clust, m = 5)

# pooling
nnodes <- 2 # number of CPU cores for parallel computing
res.pool <- clusterMI(res.imp, nnodes = nnodes, instability = FALSE)

# choice of nb.clust
\donttest{
choosenbclust(res.pool)

}
\dontshow{\}) # examplesIf}
}
\references{
Audigier, V. and Niang, N., Clustering with missing data: which equivalent for Rubin's rules? Advances in Data Analysis and Classification <doi:10.1007/s11634-022-00519-1>, 2022.
}
\seealso{
\code{\link{imputedata}}
}
