% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R
\name{clustra}
\alias{clustra}
\title{Cluster trajectories}
\usage{
clustra(
  data,
  k,
  starts = c(1, 0),
  group = NULL,
  maxdf = 30,
  iter = 10,
  mccores = 1,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame or, preferably, also a data.table with response measurements, one
response per observation. Required variables are (id, time, response).
Other variables are ignored.}

\item{k}{Number of clusters}

\item{starts}{A vector of length two. See \code{\link{start_groups}}.}

\item{group}{A vector of initial cluster assignments for unique id's in data.
Normally, this is NULL and good starts are provided by
\code{\link{start_groups}}.}

\item{maxdf}{Fitting parameters. See \code{\link{trajectories}}.}

\item{iter}{Fitting parameters. See \code{\link{trajectories}}.}

\item{mccores}{See \code{\link{trajectories}}.}

\item{verbose}{Logical to turn on more output during fit iterations.}
}
\value{
A list returned by \code{\link{trajectories}}.
}
\description{
Most users will run the wrapper \code{\link{clustra}} function, which takes
care of starting values. See vignette("clustra_vignette.Rmd") for
more details.
}
\examples{
set.seed(13)
data = gen_traj_data(n_id = c(50, 100), m_obs = 20, s_range = c(-365, -14),
              e_range = c(0.5*365, 2*365))
cl = clustra(data, k = 2, maxdf = 20, iter = 5, verbose = TRUE)
tabulate(data$group)
tabulate(data$true_group)

}
