% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{sim_sc3}
\alias{sim_sc3}
\title{SC3 Clustered simulated scRNA-seq dataset}
\format{\code{sim_sc3} is a \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} object
holding a simulated scRNA-seq dataset. The dataset has been clustered using
the \code{SC3} package with a range of values for k. The results of the clustering
are held in the \code{colData} slot with columns named \code{sc3_X_clusters} where \code{X}
is the value of \code{k}.}
\source{
\preformatted{# Simulation
library("splatter") # Version 1.2.1

sim <- splatSimulate(batchCells = 200, nGenes = 10000,
                     group.prob = c(0.4, 0.2, 0.2, 0.15, 0.05),
                     de.prob = c(0.1, 0.2, 0.05, 0.1, 0.05),
                     method = "groups", seed = 1)
sim_counts <- counts(sim)[1:1000, ]

# Clustering
library("SC3") # Version 1.7.6
library("scater") # Version 1.6.2

sim_sc3 <- SingleCellExperiment(assays = list(counts = sim_counts))
rowData(sim_sc3)$feature_symbol <- rownames(sim_counts)
sim_sc3 <- normalise(sim_sc3)
sim_sc3 <- sc3(sim_sc3, ks = 1:8, biology = FALSE, n_cores = 1)
}
}
\usage{
sim_sc3
}
\description{
A simulated scRNA-seq dataset generated using the \code{splatter} package and
clustered using \code{SC3}.
}
\keyword{datasets}
