\name{simprof.plot}
\alias{simprof.plot}
\title{Similarity Profile Analysis Dendrogram Plotter}
\description{A function to plot a dendrogram based on the results of
  simprof().
}
\usage{
simprof.plot(results, leafcolors=NA, plot=TRUE, fill=TRUE, 
leaflab="perpendicular", siglinetype=1)
}
\arguments{
  \item{results}{The object returned by \code{simprof}. However, the
    only parts \code{"results"} needs to have are \code{"hclust"} and
    \code{"significantclusters"}.
  }
  \item{leafcolors}{A vector of color names/identifiers (names or hex codes); it should be the same length as
    \code{"results$significantclusters"}. If this isn't supplied, the
    \code{\link{rainbow}} function will be used to generate enough colors
    (recommended). Because the colors are used in the order generated by
    \code{rainbow}, if there are a large number of significant clusters,
    they may appear to form a continuous color spectrum. If this is the
    case, the appropriate option is to manually supply a vector of
    colors to more clearly delineate different clusters.
  }
  \item{plot}{A logical option indicating whether to plot the dendrogram
    (\code{"TRUE"} for plot).
  }
  \item{fill}{A logical option indicating whether to color the entire
    subtree which comprises a signficant color (as opposed to just
    coloring the individual leaves).
  }
  \item{leaflab}{The option from \code{dendrogram} indicating the
    label text
    orientation. Possible values are \code{"perpendicular"} (vertical),
    \code{"textlike"} (horizontal), or \code{"none"} (labels
    suppressed).
  }
  \item{siglinetype}{A numeric option indicating the type of line to use
    for the significant clusters (the line type chosen applies to all
    significant clusters). The possible values are 0=blank, 1=solid
    (default), 2=dashed, 3=dotted, 4=dotdash, 5=longdash,
    6=twodash, and \code{"different"}. This can be a vector of line-types to use; in the event
    that there are fewer available line-types than there are significant
    groups, some line-types will be repeated. The selection of
    \code{"different"} will use try to
    automatically use as many different line-types as necessary to have
    a unique type for each significant group (the line-types will be
    used in the order of 6 through 1 so that solid is used last to
    increase clarity).
  }
}
\value{A dendrogram is returned. If \code{"plot=TRUE"}, the dendrogram
  is also plotted.}
\seealso{
  \code{\link{hclust}}, \code{\link{dendrogram}}
  }
\author{Douglas Whitaker and Mary Christman}
\examples{
\dontrun{
# Load the USArrests dataset included with R
# And use abbreviations of state names
# We leave out the third column because
# it is on a different scale
usarrests<-USArrests[,c(1,2,4)]
rownames(usarrests)<-state.abb
# Run simprof on the data
res <- simprof(data=usarrests, 
method.distance="braycurtis")
# Graph the result
pl.color <- simprof.plot(res)
}
}  
\keyword{cluster}
\keyword{significant cluster}
\keyword{dendrogram}