% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_data_converters.R
\name{split_clusters_to_list}
\alias{split_clusters_to_list}
\title{Split Clusters to List}
\usage{
split_clusters_to_list(cluster)
}
\arguments{
\item{cluster}{The output generated from the `cluster()` function.}
}
\value{
a named `list` of clusters.
}
\description{
`split_clusters_to_list()` will extract clusters from the
cluster generated `data.frame`. It will then turn those clusters
into a list. This allows users to more easily visualize their data.
}
\examples{

 cutoff <- 0.2
 count_table <- read_count(example_path("amazon.full.count_table"))
 distance_data <- read_dist(example_path("amazon_column.dist"),
                            count_table, cutoff, FALSE)
 cluster_results <- cluster(distance_data, cutoff, method = "opticlust")

 cluster_list <- split_clusters_to_list(cluster_results)
}
