% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmfslow.R
\name{cmfStep}
\alias{cmfStep}
\title{One step the cmf function (internal)}
\usage{
cmfStep(x, M, y, decisionFunction, msel, medsamp, ...)
}
\arguments{
\item{x}{a numeric vector, standardised exogenous variable}

\item{M}{a data frame with column names, potential mediators}

\item{y}{a numeric vector, outcome variable}

\item{decisionFunction}{a function with as inputs x, m, y, parameters,
and as output a TRUE (include) or FALSE (exclude) statement}

\item{msel}{binary vector of mediator selections at step i}

\item{medsamp}{which variables to consider}

\item{...}{parameters passed to decisionFunction}
}
\value{
binary vector of mediator selections at step i+1
}
\description{
One step the cmf function (internal)
}
\examples{
# generate some data
dat <- generateMed(a = (1:10)/20, b = (1:10)/20)
cmfilter:::cmfStep(dat$x, dat[,-c(1, 12)], dat$y, 
                   decisionFunction = cmfilter:::prodCoef,
                   msel = c(1, 1, 1, 0, 0, 0, 0, 0, 0, 0),
                   medsamp = 1:10)

}
\keyword{internal}
