% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{bootstrap_variance}
\alias{bootstrap_variance}
\title{Estimate Variance of Parameters Using Bootstrap Method}
\usage{
bootstrap_variance(features, x, delta1, delta2, initial_params, n_bootstrap, optimMethod)
}
\arguments{
\item{features}{A numeric matrix of predictor variables. Each row corresponds to an observation.}

\item{x}{A numeric vector of failure times corresponding to observations.}

\item{delta1}{A binary vector indicating the occurrence of the first competing event (1 for observed).}

\item{delta2}{A binary vector indicating the occurrence of the second event (1 for observed).}

\item{initial_params}{A numeric vector of initial parameter values to start the optimization.}

\item{n_bootstrap}{An integer specifying the number of bootstrap samples.}

\item{optimMethod}{A character string specifying the optimization method to use. Default is \code{"BFGS"}.}
}
\value{
A list containing:
\itemize{
\item \code{variances}: A numeric vector representing the variance of the estimated parameters.
\item \code{bootstrap_estimates}: A matrix of parameter estimates for each bootstrap sample.
}
}
\description{
This function estimates the variance of model parameters using the bootstrap method.
It repeatedly samples the data with replacement, estimates the parameters for each sample,
and computes the variance of the estimated parameters.
}
\details{
This function performs bootstrap sampling to estimate the variance of the model parameters.
It requires the data to be initialized using \code{Initialize} before being called.
}
\examples{
library(cmpp)
features <- matrix(rnorm(100), ncol = 5)
x <- rnorm(20)
delta1 <- sample(0:1, 20, replace = TRUE)
delta2 <- 1 - delta1
initial_params <- c(0.01, 0.01, 0.01, 0.01)
n_bootstrap <- 100
results <- bootstrap_variance(features, x, delta1, delta2, 
initial_params, n_bootstrap, optimMethod = "BFGS")
print(results$variances)
print(results$bootstrap_estimates)
}
