% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_nucleotide_div.R
\name{sumstat_nucleotide_div}
\alias{sumstat_nucleotide_div}
\title{Calculates the Nucleodite Diversity Pi}
\usage{
sumstat_nucleotide_div(name = "pi", population = 1,
  transformation = identity)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{population}{The population for which the statistic is calculated.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\value{
On simulation, this returns a vector with the value of pi for
  each locus.
}
\description{
This calculates the nucleotide diversity / mean pairwise difference usually
for a population.
}
\details{
The statistic is usually denoted by pi and can be used
as an estimator for the per locus scaled muation rate theta.

It was introducted by

Nei and Li (1979). "Mathematical Model for Studying Genetic Variation in
 Terms of Restriction Endonucleases". PNAS 76 (10): 5269-73.
 doi:10.1073/pnas.76.10.5269.
}

