% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_outgroup.R
\name{feat_outgroup}
\alias{feat_outgroup}
\title{Feature: Outgroup}
\usage{
feat_outgroup(population, locus_group = "all")
}
\arguments{
\item{population}{The population that is marked as outgroup.}

\item{locus_group}{The loci for which this features is used. Can either be
\code{"all"} (default), in which case the feature is used for simulating
all loci, or a numeric vector. In the latter case, the feature is only
used for the loci added in \code{locus_} commands  with the corresponding
index starting from 1 in order in which the commands where added to the
model. For example, if a model has
\code{locus_single(10) + locus_averaged(10, 11) + locus_single(12)} and
this argument is \code{c(2, 3)}, than the feature is used for all but
the first locus (that is locus 2 - 12).}
}
\value{
The feature, which can be added to a model created with
  \code{\link{coal_model}} using \code{+}.
}
\description{
This feature declares an existing population as outgroup. Outgroups are used
to determine the ancestral allele in finite sites simulations and are required
there. All individuals of the outgroup are ignored when calculating summary
statistics. If the outgroup consists of multiple individuals, all positions
where the individuals have different alleles are ignored.
}
\examples{
# A simple finite sites model
model <- coal_model(c(4, 6, 1), 2, 10) +
   feat_outgroup(3) +
   feat_pop_merge(0.5, 2, 1) +
   feat_pop_merge(2, 3, 1) +
   feat_mutation(5, model = "GTR", gtr_rates = 1:6)
}
\seealso{
For creating a model: \code{\link{coal_model}}

Other features: 
\code{\link{feat_growth}()},
\code{\link{feat_ignore_singletons}()},
\code{\link{feat_migration}()},
\code{\link{feat_mutation}()},
\code{\link{feat_pop_merge}()},
\code{\link{feat_recombination}()},
\code{\link{feat_selection}()},
\code{\link{feat_size_change}()},
\code{\link{feat_unphased}()}
}
\concept{features}
