\name{bal.tab.weightit}
\alias{bal.tab.weightit}
\alias{bal.tab.weightitMSM}
\title{
Balance Statistics for \code{WeightIt} Objects
}
\description{
Generates balance statistics for \code{weightit} and \code{weightitMSM} objects from \pkg{WeightIt}.
}
\usage{
\method{bal.tab}{weightit}(x, 
        stats,
        int = FALSE,
        poly = 1,
        distance = NULL,
        addl = NULL,
        data = NULL,
        continuous,
        binary,
        s.d.denom,
        thresholds = NULL,
        weights = NULL,
        cluster = NULL,
        imp = NULL,
        pairwise = TRUE,
        s.weights = NULL,
        abs = FALSE,
        subset = NULL,
        quick = TRUE,
        ...)
}

\arguments{
  \item{x}{
a \code{weightit} or \code{weightitMSM} object; the output of a call to \pkgfun{WeightIt}{weightit} or \pkgfun{WeightIt}{weightitMSM}.
}
  \item{stats, int, poly, addl, data, continuous, binary, thresholds, weights, cluster, imp, pairwise, abs, subset, quick, \dots}{
see \fun{bal.tab} for details.

See below for special notes on the \code{distance}, \code{s.d.denom}, and \code{s.weights} arguments.
}

The following arguments have special notes when used with \code{weightit} and \code{weightitMSM} objects:

  \item{distance}{
propensity scores generated by \code{weightit()} and \code{weightitMSM()} are automatically included and named "prop.score".
}
  \item{s.d.denom}{
if not specified, \code{bal.tab()} will figure out which one is best based on the estimand of the \code{weightit} object: if ATT, \code{"treated"}; if ATC, \code{"control"}; otherwise \code{"pooled"}. Abbreviations allowed.
}
  \item{s.weights}{
if \code{s.weights} was supplied in the call to \code{weightit()} or \code{weightitMSM()}, they will automatically be included and do not need be specified again (though there is no harm if they are).
}
}
\details{
\code{bal.tab.weightit()} generates a list of balance summaries for the \code{weightit} object given.
}
\value{
For point treatments, if clusters and imputations are not specified, an object of class \code{"bal.tab"} containing balance summaries for the \code{weightit} object. See \fun{bal.tab} for details.

If imputations are specified, an object of class \code{"bal.tab.imp"} containing balance summaries for each imputation and a summary of balance across imputations. See \code{\link[=class-bal.tab.imp]{bal.tab.imp}} for details.

If \code{weightit()} is used with multi-category treatments, an object of class \code{"bal.tab.multi"} containing balance summaries for each pairwise treatment comparison. See \code{\link[=class-bal.tab.multi]{bal.tab.multi}} for details.

If \code{weightitMSM()} is used for longitudinal treatments, an object of class \code{"bal.tab.msm"} containing balance summaries for each time period. See \code{\link[=class-bal.tab.msm]{bal.tab.msm}} for details.

If clusters are specified, an object of class \code{"bal.tab.cluster"} containing balance summaries within each cluster and a summary of balance across clusters. See \code{\link[=class-bal.tab.cluster]{bal.tab.cluster}} for details.
}

\author{
Noah Greifer 
}

\seealso{
\fun{bal.tab} for details of calculations.
}
\examples{\dontshow{if (all(sapply(c("WeightIt", "twang"), requireNamespace, quietly = TRUE))) force(\{ # examplesIf}
library(WeightIt)
data("lalonde", package = "cobalt")

## Basic propensity score weighting
w.out1 <- weightit(treat ~ age + educ + race + 
                     married + nodegree + re74 + re75, 
                   data = lalonde, method = "ps")
bal.tab(w.out1, un = TRUE, m.threshold = .1, 
        v.threshold = 2)

## Weighting with a multi-category treatment
w.out2 <- weightit(race ~ age + educ + married + 
                     nodegree + re74 + re75, 
                   data = lalonde, method = "ps",
                   estimand = "ATE", use.mlogit = FALSE)
bal.tab(w.out2, un = TRUE)
bal.tab(w.out2, un = TRUE, pairwise = FALSE)

## IPW for longitudinal treatments
data("iptwExWide", package = "twang")
wmsm.out <- weightitMSM(list(tx1 ~ use0 + gender,
                             tx2 ~ use0 + gender + use1 + tx1,
                             tx3 ~ use0 + gender + use1 + tx1 + use2 + tx2),
                        data = iptwExWide,
                        stabilize = TRUE)
bal.tab(wmsm.out)
\dontshow{\}) # examplesIf}}
\keyword{tables}
