% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal.tab.optmatch.R
\name{bal.tab.optmatch}
\alias{bal.tab.optmatch}
\title{Balance Statistics for \code{optmatch} Objects}
\usage{
\method{bal.tab}{optmatch}(
  x,
  formula = NULL,
  data = NULL,
  treat = NULL,
  covs = NULL,
  estimand = NULL,
  stats,
  int = FALSE,
  poly = 1,
  distance = NULL,
  addl = NULL,
  continuous,
  binary,
  s.d.denom,
  thresholds = NULL,
  weights = NULL,
  cluster = NULL,
  imp = NULL,
  pairwise = TRUE,
  s.weights = NULL,
  abs = FALSE,
  subset = NULL,
  quick = TRUE,
  ...
)
}
\arguments{
\item{x}{an \code{optmatch} object (the output of a call to \pkgfun{optmatch}{pairmatch} or \pkgfun{optmatch}{fullmatch}).}

\item{formula}{a \code{formula} with the treatment variable as the response and the covariates for which balance is to be assessed as the predictors. All named variables must be in \code{data}. See Details.}

\item{data}{a data frame containing variables named in \code{formula}, if supplied, and other arguments.}

\item{treat}{a vector of treatment statuses. See Details.}

\item{covs}{a data frame of covariate values for which to check balance. See Details.}

\item{estimand}{\code{character}; whether the desired estimand is the "ATT", "ATC", or "ATE". Default is "ATT".}

\item{stats}{\code{character}; which statistic(s) should be reported. See \code{\link[=balance-statistics]{stats}} for allowable options. For binary and multi-category treatments, \code{"mean.diffs"} (i.e., mean differences) is the default. For continuous treatments, \code{"correlations"} (i.e., treatment-covariate Pearson correlations) is the default. Multiple options are allowed.}

\item{int}{\code{logical} or \code{numeric}; whether or not to include 2-way interactions of covariates included in \code{covs} and in \code{addl}. If \code{numeric}, will be passed to \code{poly} as well.}

\item{poly}{\code{numeric}; the highest polynomial of each continuous covariate to display. For example, if 2, squares of each continuous covariate will be displayed (in addition to the covariate itself); if 3, squares and cubes of each continuous covariate will be displayed, etc. If 1, the default, only the base covariate will be displayed. If \code{int} is numeric, \code{poly} will take on the value of \code{int}.}

\item{distance}{an optional formula or data frame containing distance values (e.g., propensity scores) or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the argument to \code{data}, if specified. For longitudinal treatments, can be a list of allowable arguments, one for each time point.}

\item{addl}{an optional formula or data frame containing additional covariates for which to present balance or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the arguments to the input object, \code{covs}, and \code{data}, if specified. For longitudinal treatments, can be a list of allowable arguments, one for each time point.}

\item{continuous}{whether mean differences for continuous variables should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"std"}. Abbreviations allowed. This option can be set globally using \code{\link[=set.cobalt.options]{set.cobalt.options()}}.}

\item{binary}{whether mean differences for binary variables (i.e., difference in proportion) should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"raw"}. Abbreviations allowed. This option can be set globally using \code{\link[=set.cobalt.options]{set.cobalt.options()}}.}

\item{s.d.denom}{\code{character}; how the denominator for standardized mean differences should be calculated, if requested. See \code{\link[=col_w_smd]{col_w_smd()}} for allowable options. Abbreviations allowed. If unspecified, \code{bal.tab()} will figure out which one is best based on the \code{estimand}, if given (for ATT, \code{"treated"}; for ATC, \code{"control"}; otherwise \code{"pooled"}) and other clues if not.}

\item{thresholds}{a named vector of balance thresholds, where the name corresponds to the statistic (i.e., in \code{stats}) that the threshold applies to. For example, to request thresholds on mean differences and variance ratios, one can set \code{thresholds = c(m = .05, v = 2)}. Requesting a threshold automatically requests the display of that statistic. When specified, extra columns are inserted into the Balance table describing whether the requested balance statistics exceeded the threshold or not. Summary tables tallying the number of variables that exceeded and were within the threshold and displaying the variables with the greatest imbalance on that balance measure are added to the output.}

\item{weights}{a vector, list, or \code{data.frame} containing weights for each unit, or a string containing the names of the weights variables in \code{data}, or an object with a \code{\link[=get.w]{get.w()}} method or a list thereof. The weights can be, e.g., inverse probability weights or matching weights resulting from a matching algorithm.}

\item{cluster}{either a vector containing cluster membership for each unit or a string containing the name of the cluster membership variable in \code{data} or the input object. See \code{\link{class-bal.tab.cluster}} for details.}

\item{imp}{either a vector containing imputation indices for each unit or a string containing the name of the imputation index variable in \code{data} or the input object. See \code{\link{class-bal.tab.imp}} for details. Not necessary if \code{data} is a \code{mids} object.}

\item{pairwise}{whether balance should be computed for pairs of treatments or for each treatment against all groups combined. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details. This can also be used with a binary treatment to assess balance with respect to the full sample.}

\item{s.weights}{Optional; either a vector containing sampling weights for each unit or a string containing the name of the sampling weight variable in \code{data}. These function like regular weights except that both the adjusted and unadjusted samples will be weighted according to these weights if weights are used.}

\item{abs}{\code{logical}; whether displayed balance statistics should be in absolute value or not.}

\item{subset}{a \code{logical} or \code{numeric} vector denoting whether each observation should be included or which observations should be included. If \code{logical}, it should have length equal to the number of units. \code{NA}s will be treated as \code{FALSE}. This can be used as an alternative to \code{cluster} to examine balance on subsets of the data.}

\item{quick}{\code{logical}; if \code{TRUE}, will not compute any values that will not be displayed. Set to \code{FALSE} if computed values not displayed will be used later.}

\item{...}{for some input types, other arguments that are required or allowed. Otherwise, further arguments to control display of output. See \link[=display-options]{display options} for details.}
}
\value{
If clusters and imputations are not specified, an object of class \code{"bal.tab"} containing balance summaries for the given object. See \code{\link[=bal.tab]{bal.tab()}} for details.

If clusters are specified, an object of class \code{"bal.tab.cluster"} containing balance summaries within each cluster and a summary of balance across clusters. See \code{\link{class-bal.tab.cluster}} for details.
}
\description{
Generates balance statistics for output objects from \pkg{optmatch}.
}
\details{
\code{bal.tab()} generates a list of balance summaries for the object given. The input to \code{bal.tab.optmatch()} must include either both \code{formula} and \code{data} or just \code{covs} (\code{treat} is not necessary).
}
\examples{
\dontshow{if (requireNamespace("ebal", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("lalonde", package = "cobalt")

lalonde$prop.score <- glm(treat ~ age + educ + race + 
                              married + nodegree + re74 + re75, 
                          data = lalonde, family = binomial)$fitted.values
pm <- optmatch::pairmatch(treat ~ prop.score, data = lalonde)

## Using formula and data; LHS of formula not required
bal.tab(pm, formula = ~ age + educ + race +
            married + nodegree + re74 + re75,
        data = lalonde)

## Using covs
covs <- subset(lalonde, select = -c(re78, treat))
bal.tab(pm, covs = covs)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bal.tab]{bal.tab()}} for details of calculations.
}
