% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cobiclust.R
\name{cobiclust}
\alias{cobiclust}
\title{Perform a biclustering adapted to overdispersed count data.}
\usage{
cobiclust(x, K = 2, G = 3, nu_j = NULL, a = NULL, akg = FALSE,
  cvg_lim = 1e-05, nbiter = 5000)
}
\arguments{
\item{x}{the input matrix of observed data.}

\item{K}{an integer specifying the number of groups in rows.}

\item{G}{an integer specifying the number of groups in columns.}

\item{nu_j}{a vector of . The length is equal to the number of colums.}

\item{a}{an numeric.}

\item{akg}{a logical variable indicating whether to use a common dispersion parameter (akg = FALSE) or a dispersion parameter per cocluster (akg = TRUE).}

\item{cvg_lim}{a number specifying the threshold used for convergence criterion (cvg_lim = 1e-05 by default).}

\item{nbiter}{the maximal number of iterations for the global loop of variational EM algorithm (nbiter = 5000  by default).}
}
\value{
An object of class cobiclustering
}
\description{
Perform a biclustering adapted to overdispersed count data.
}
\examples{
npc <- c(50, 40) # nodes per class
KG <- c(2, 3) # classes
nm <- npc * KG # nodes
Z <- diag( KG[1]) \%x\% matrix(1, npc[1], 1)
W <- diag(KG[2]) \%x\% matrix(1, npc[2], 1)
L <- 70 * matrix( runif( KG[1] * KG[2]), KG[1], KG[2])
M_in_expectation <- Z \%*\% L \%*\% t(W)
size <- 50
M<-matrix(
 rnbinom(
   n = length(as.vector(M_in_expectation)),
   mu = as.vector(M_in_expectation), size = size)
 , nm[1], nm[2])
rownames(M) <- paste("OTU", 1:nrow(M), sep = "_")
colnames(M) <- paste("S", 1:ncol(M), sep = "_")
res <- cobiclust(M, K = 2, G = 3, nu_j = rep(1,120), a = 1/size, cvg_lim = 1e-5)
}
\seealso{
\code{\link{cobiclustering}} for the cobiclustering class.
}
