% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocoSim.R
\name{cocoSim}
\alias{cocoSim}
\title{Simulation of Count Time Series}
\usage{
cocoSim(
  type,
  order,
  par,
  length,
  xreg = NULL,
  init = NULL,
  julia = FALSE,
  julia_seed = NULL,
  link_function = "log"
)
}
\arguments{
\item{type}{character, either "Poisson" or "GP" indicating the type of the innovation distribution}

\item{order}{integer, either 1 or 2 indicating the order of the model}

\item{par}{numeric vector, the parameters of the model, the number of elements
in the vector depends on the type and order specified.}

\item{length}{integer, the number of observations in the generated time series}

\item{xreg}{data frame of control variables (defaul: NULL)}

\item{init}{numeric vector, initial data to use (default: NULL). See details
for more information on the usage.}

\item{julia}{If TRUE, the \proglang{julia} implementation is used. In this case, init is ignored but it might be faster (default: FALSE).}

\item{julia_seed}{Seed for the \proglang{julia} implementation. Only used if \proglang{julia} equals TRUE.}

\item{link_function}{Specifies the link function for the conditional mean of the innovation (\eqn{\lambda}). The default is \code{log}, but other available options include \code{identity} and \code{relu}. This parameter is applicable only when covariates are used. Note that using the \code{identity} link function may result in \eqn{\lambda} becoming negative. To prevent this, ensure all covariates are positive and restrict the parameter \eqn{\beta} to positive values.}
}
\value{
a vector of the simulated time series
}
\description{
The function generates a time series of low counts from the (G)PAR model class for a specified
innovation distribution, sample size, lag order,
and parameter values.
}
\details{
The function checks for valid input of the type, order, parameters, and initial data
before generating the time series.

The init parameter allows users to set a custom burn-in period
for the simulation. By default, when simulating with covariates, no burn-in
period is specified since there is no clear choice on the covariates.
However, the init argument gives users the flexibility to select an
appropriate burn-in period for the covariate case. One way to do this is to
simulate a time series using \code{\link{cocoSim}} with appropriate covariates and pass the
resulting time series to the
init argument of a new \code{\link{cocoSim}} run so that the first time series is used as
the burn-in period.
If init is not specified for the covariate case, a warning will be returned
to prompt the user to specify a custom burn-in period. This helps ensure that
the simulation accurately captures the dynamics of the system being modeled.
}
\examples{
lambda <- 1
alpha <- 0.4
set.seed(12345)

# Simulate using the RCPP implementation
data_rcpp <- cocoSim(order = 1, type = "Poisson", par = c(lambda, alpha), length = 100)
}
\author{
Manuel Huth
}
