% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/synthetic_datasets.R
\name{variation_shared_by}
\alias{variation_shared_by}
\title{Return a specific variation component}
\usage{
variation_shared_by(dc, type, center = T, scale = F)
}
\arguments{
\item{dc}{A data collection from one of the create_syn_data_*() functions}

\item{type}{Type of variation to extract, allowed values c('all','subset','all_and_subset')}

\item{center}{(optional) Should the output data be centered?}

\item{scale}{(optional) Should the output data be scaled?}
}
\value{
A list of data.frames containing the desired variation component
}
\description{
Variation can be shared by:
 'all'     all datasets
 'subset'  a subset of the datasets (excluding variation already in 'all')
 'all_and_subset' a union of the above

 The returned data never contains noise (which is considered to be part
 of each datasets unique variation). The linear toy datasets do not contain
 variation unique to a dataset other than pure noise.
}
\examples{
\dontrun{
dc <- create_syn_data_toy()
ldSharedByAll = variation_shared_by(dc, "all", center = F)
ldSharedBySome = variation_shared_by(dc, "subset", center = F)
ldNonUnique = variation_shared_by(dc, "all_and_subset", center = F)
dNoise <- mapply(function(x,y){x-y}, x=dc$data, y=ldNonUnique, SIMPLIFY = F)
ggplot_dclst(list(observed = dc$data,
                 shared.by.all = ldSharedByAll,
                 shared.by.some = ldSharedBySome,
                 noise = dNoise),
             ylim = c(-3, 3))
}
}

