% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_functions.R
\name{explore_zeros}
\alias{explore_zeros}
\title{explore_zeros}
\usage{
explore_zeros(x, id1, id2, strata = NULL)
}
\arguments{
\item{x}{abundance table (rows are samples, columns are variables (taxa))}

\item{id1}{column number in x for the first taxa}

\item{id2}{column number in x for the second taxa}

\item{strata}{stratification variable (default = NULL)}
}
\value{
a list with the frequency table and the associated bar plot
}
\description{
Provides the proportion of zeros for a pair of variables (taxa) in table x and the proportion of samples
with zero in both variables. A bar plot with this information is also provided.
Results can be stratified by a categorical variable.
}
\examples{

data(HIV, package = "coda4microbiome")

explore_zeros(x_HIV,5,6)

explore_zeros(x_HIV,5,6, strata=y_HIV)


}
\author{
M. Calle - T. Susin
}
