% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codalm_em.R
\name{predict_codalm}
\alias{predict_codalm}
\title{Prediction for Transformation-free Linear Regression for Compositional Outcomes and Predictors}
\usage{
predict_codalm(object, newx)
}
\arguments{
\item{object}{A \code{codalm} model}

\item{newx}{A matrix of compositional predictors. Each row is an observation, and must sum to 1.
If any rows do not sum to 1, they will be renormalized}
}
\value{
A \eqn{D_s} x \eqn{D_r} compositional coefficient matrix, where
\eqn{D_s} and \eqn{D_r}  are the dimensions of the compositional predictor
and outcome, respectively
}
\description{
Obtains compositional predictions for new compositional covariates using
an established codalm model.
}
\examples{
data("educFM", package = 'robCompositions')
father <- as.matrix(educFM[,2:4])
y <- father / rowSums(father)
mother <- as.matrix(educFM[,5:7] )
x <- mother/rowSums(mother)
codalm_model <- codalm(y[1:20,], x[1:20,])
predict_codalm(codalm_model, x[-(1:20),])
}
