% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/turnover.R
\name{turnover_allyears}
\alias{turnover_allyears}
\title{A function to calculate species turnover between years}
\usage{
turnover_allyears(df, time.var, species.var, abundance.var,
  metric = c("total", "disappearance", "appearance"))
}
\arguments{
\item{df}{A dataframe containing time, species and abundance columns}

\item{time.var}{The name of the time column from df}

\item{species.var}{The name of the species column from df}

\item{abundance.var}{The name of the abundance column from df}

\item{metric}{The turnover metric to return; the default, total, returns summed appearances and disappearances relative to total species richness across both years
\itemize{
 \item{appearance: }{ returns the number of appearances in the second year relative to total species richness across both years }
  \item{disappearance: }{ returns the number of disappearances in the second year relative to the total species richness across both years }
  }}
}
\value{
output A dataframe containing the specificed turnover metric and year
}
\description{
A function to calculate species turnover between years
}

