% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate_difference.R
\name{multivariate_difference}
\alias{multivariate_difference}
\title{Using dissimilarity-based metrics to calculate differences in
 composition and dispersion between pairs of treatments at a single time
 point}
\usage{
multivariate_difference(df, time.var = NULL, species.var, abundance.var,
  replicate.var, treatment.var, reference.treatment = NULL)
}
\arguments{
\item{df}{A data frame containing an optional time column, species, abundance and replicate, and treatment columns}

\item{time.var}{The name of the optional time column}

\item{species.var}{The name of the species column}

\item{abundance.var}{The name of the abundance column}

\item{replicate.var}{The name of the replicate column. Replicate must be unique within the dataset and cannot be nested within treatments or blocks.}

\item{treatment.var}{the name of the treatment column}

\item{reference.treatment}{The name of the optional treatment that all other treatments will be compared to (e.g. only controls will be compared to all other treatments). If not specified all pairwise treatment comparisons will be made.}
}
\value{
The multivariate_difference function returns a data frame with the
  following attributes:
\itemize{
 \item{treatment.var: }{A column that has same name and type as the treatment.var column, if treatment.var is specified.}
 \item{treatment.var2: }{A column that has the same type as the treatment.var  column, and is named treatment.var with a 2 appended to it.}
 \item{composition_diff: }{A numeric column that is the euclidean distance  between the centroids of two treatments at a single point in time.}
 \item{abs_dispersion_diff: }{A numeric column that is the absolute value of the difference in the average dispersion of the replicates around the centroid for the two treatments.}
 \item{trt_greater_disp: }{A column that has same type as the treatment.var  column, and specifies which of the two  treatments has greater dispersion.}
 \item{time.var: }{A characteristic column that has the same name and type as the time.var column, if specified.}
}
}
\description{
Calculates the difference in composition and dispersion between  treatments based off a Bray-Curtis dissimilarity matrix at a single point in time. Composition difference is the euclidean distance between the centroids of different treatments. Since centroid distance is based on plotted distance between centroids, it is context dependent and depends on how many centroids are being plotted. The centroid distance between treatments depends on how many treatments are being compared. Dispersion difference is the difference of average dispersion of each replicate to its centroid between two treatments.
}
\examples{
 
data(pplots)
# Without time
df <- subset(pplots, year == 2002)
multivariate_difference(df, 
                        replicate.var = "plot", 
                        treatment.var = "treatment", 
                        species.var = "species", 
                        abundance.var = "relative_cover")
# There are 6 replicates for each of three treatments, thus 18 total
# observations.

# Without time and with reference treatment
df <- subset(pplots, year == 2002)
multivariate_difference(df, 
                        replicate.var = "plot", 
                        treatment.var = "treatment", 
                        species.var = "species", 
                        abundance.var = "relative_cover",
                        reference.treatment = "N1P0")
# There are 6 replicates for each of three treatments, thus 18 total
# observations.

# With time
multivariate_difference(pplots, 
                        time.var = "year", 
                        replicate.var = "plot", 
                        species.var = "species", 
                        abundance.var = "relative_cover", 
                        treatment.var = "treatment")
# In each year there are 6 replicates for each of three treatments, for a
# total of 18 observations.
}
\references{
Avolio et al. Submitted to MEE, Avolio et al. 2015, Marti Anderson et al. 2006
}
