% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{sim.rings}
\alias{sim.rings}
\title{Simulate the radiocarbon dating of tree-rings}
\usage{
sim.rings(
  name = "mytree",
  age.min = 100,
  length = 400,
  gaps = 20,
  offset = 0,
  scatter = 2 * error,
  error = 0.02,
  min.error = 10,
  tree.dir = "trees",
  sep = ",",
  cc = 1,
  postbomb = FALSE,
  ask = TRUE
)
}
\arguments{
\item{name}{Name of the simulated tree-ring set. Defaults to \code{"mytree"}.}

\item{age.min}{Minimum age of the simulation.}

\item{length}{Length of the sequence (if gaps are given as constant). Could be set at e.g 400 for an oak, but many trees will not live as long so shorter sequences could also make sense.}

\item{gaps}{How many calendar years there are between the dated rings. Can be set constant (one value, e.g. 20), or alternatively the gaps can be provided as a list of values.}

\item{offset}{The ages could be offset by some constant value. Defaults to 0.}

\item{scatter}{There is always a degree of scatter between measurements, and the amount of scatter can be modelled using, e.g., \code{scatter=2*error}. Set at 0 to model radiocarbon dates that are 100\% faithful to the calibration curve (very unlikely!).}

\item{error}{Laboratory error of the radiocarbon dates as percentage of the mean. Defaults to 0.02.}

\item{min.error}{Minimum laboratory to be reported. Defaults to 10 (C-14 year).}

\item{tree.dir}{The directory where the folders of the individual trees live. Defaults to \code{tree.dir="trees"}.}

\item{sep}{Separator for the fields in the .csv file. Defaults to a comma.}

\item{cc}{Calibration curve to be used. Could be 1 (IntCal20; default), 2 (Marine20), 3 (SHCal20) or 4 (custom curve).}

\item{postbomb}{Negative C-14 ages (younger than 0 cal BP or AD 1950) should be modelled using a postbomb curve. This could be 1 (northern-hemisphere region 1), 2 (NH region 2), 3 (NH region 3), 4 (southern hemisphere regions 1-2), or 5 (SH region 3).}

\item{ask}{Ask if a folder may be made and files written into it}
}
\value{
A file containing 5 columns: the simulated calendar ages, the radiocarbon ages, their errors, the rings (starting with year 0 and working backward in time), and the calibration curve to be used.
}
\description{
Simulate the dense radiocarbon dating of a tree or other deposit with exactly known yearly rings, and thus with gaps of exactly known age. The radiocarbon dates are assumed to have a degree of lab error and scatter. A (constant) offset can also be modelled.
}
\examples{
  treedir <- tempdir()
  sim.rings("manyrings", age.min=1000, length=400, gaps=10, tree.dir=treedir)
  rings("manyrings", tree.dir=treedir)
}
\author{
Maarten Blaauw, J. Andres Christen
}
