% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-quotes.R
\name{df.quotes.scm.concept}
\alias{df.quotes.scm.concept}
\title{Extract the quotes of a project linked to selected concepts}
\usage{
df.quotes.scm.concept(project, units, selected.concept)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{units}{A string vector giving the names of the units (i.e. classes linked to documents) that will be include in the SCM. It is a second type of filter.}

\item{selected.concept}{A vector of character/integer value(s), the id(s) of one or many concept(s) of the map}
}
\value{
A data frame of relationships and quotes
}
\description{
Extract the quotes of a project linked to selected concepts
}
\details{
Extract the quotes of a project linked to selected concepts. Units is a mandatory parameter as this function was initially developped for given the quotes linked to significantly different concepts between groups of documents (i.e.  units).
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

df.quotes.scm.concept(my.project, "Québec", 4)
df.quotes.scm.concept(my.project, "Québec", "2")
}
