% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coi5p.r
\name{indel_check}
\alias{indel_check}
\alias{indel_check.coi5p}
\title{Check if coi5p sequence likely contains an indel error.}
\usage{
indel_check(x, ...)

\method{indel_check}{coi5p}(x, ..., indel_threshold = -358.88)
}
\arguments{
\item{x}{a coi5p class object for which frame() and translate() have been run.}

\item{...}{additional arguments to be passed between methods.}

\item{indel_threshold}{the log likelihood threshold used to assess whether or not sequences
are likely to contain an indel. Default is -358.88. Values lower than this will be classified
as likely to contain an indel and values higher will be classified as not likely to contain an indel.}
}
\value{
an object of class \code{"coi5p"}
}
\description{
Check if coi5p sequence likely contains an indel error.
}
\examples{
#previously run functions:
dat = coi5p(example_nt_string)
dat = frame(dat)
dat = translate(dat)
#current function
dat = indel_check(dat)
#with custom indel threshold
dat = indel_check(dat, indel_threshold = -400)
#additional components in output coi5p object:
dat$stop_codons #Boolean - Indicates if there are stop codons in the amino acid sequence.
dat$indel_likely #Boolean - Indicates if there is likely a insertion or deletion in the sequence.
dat$aaScore #view the amino acid log likelihood score
}
\seealso{
\code{\link{coi5p}}

\code{\link{frame}}

\code{\link{translate}}
}
