% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordereddict.R
\docType{data}
\name{OrderedDictL}
\alias{OrderedDictL}
\title{Ordered Dictionary (list based)}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
OrderedDictL
}
\description{
The \code{OrderedDictL} class creates an ordered dictionary.
The key-value pairs are stored in an R List.
Pure R implementation, mainly for benchmark.
}
\section{Usage}{

\preformatted{
OrderedDictL$new()
OrderedDictL$set(key, value)
OrderedDictL$get(key, default = NULL)
OrderedDictL$remove(key)
OrderedDictL$pop(key, default = NULL)
OrderedDict$popitem(last = TRUE)
OrderedDictL$has(key)
OrderedDictL$keys()
OrderedDictL$values()
OrderedDictL$update(d)
OrderedDictL$clear()
OrderedDictL$size()
OrderedDictL$as_list()
}
}

\section{Argument}{

\itemize{
\item \code{key}: any R object, key of the item
\item \code{value}: any R object, value of the item
\item \code{default}: optinal, the default value of an item if the key is not found
\item \code{d}: an OrderedDict or OrderedDictL
}
}

\examples{
d <- OrderedDictL$new()
d$set("apple", 5)
d$set("orange", 10)
d$set("banana", 3)
d$get("apple")
d$as_list()  # the order the item is preserved
d$pop("orange")
d$as_list()  # "orange" is removed
}
\seealso{
\link{Dict} and \link{OrderedDict}
}
\keyword{datasets}
