% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c4a_gui.R, R/c4a_table.R
\name{c4a_gui}
\alias{c4a_gui}
\alias{c4a_table}
\title{Graphical user interface to analyse palettes}
\usage{
c4a_gui(type = "cat", n = NA, series = "all")

c4a_table(
  type = c("cat", "seq", "div", "bivs", "bivc", "bivd", "bivg"),
  n = NULL,
  m = NULL,
  cvd.sim = c("none", "deutan", "protan", "tritan"),
  sort = "name",
  text.format = "hex",
  text.col = "same",
  series = "all",
  range = NA,
  include.na = FALSE,
  show.scores = FALSE,
  columns = NA,
  verbose = TRUE
)
}
\arguments{
\item{type}{type of palette. Run \code{\link{c4a_types}} to see the implemented types and their description. For \code{c4a_gui} it only determines which type is shown initially.}

\item{n, m}{\code{n} is the number of displayed colors. For bivariate palettes \code{"biv"}, \code{n} and \code{m} are the number of columns and rows respectively. If omitted: for \code{"cat"} the full palette is displayed, for \code{"seq"} and \code{"div"}, 9 colors, and for \code{"bivs"}/\code{"bivc"}/\code{"bivd"}/\code{"bivg"} 4 columns and rows. For \code{c4a_gui} it only determines which number of colors initially.}

\item{series}{Series of palettes to show. See \code{\link{c4a_series}} for options. By default, \code{"all"}, which means all series. For \code{c4a_gui} it only determines which series are shown initially.}

\item{cvd.sim}{color vision deficiency simulation: one of \code{"none"}, \code{"deutan"}, \code{"protan"}, \code{"tritan"}}

\item{sort}{column name to sort the data. The available column names depend on the arguments \code{type} and \code{show.scores}. They are listed in the warning message. Use a \code{"-"} prefix to reverse the order.}

\item{text.format}{The format of the text of the colors. One of \code{"hex"}, \code{"RGB"} or \code{"HCL"}.}

\item{text.col}{The text color of the colors. By default \code{"same"}, which means that they are the same as the colors themselves (so invisible, but available for selection). \code{"auto"} means automatic: black for light colors and white for dark colors.}

\item{range}{vector of two numbers that determine the range that is used for sequential and diverging palettes. Both numbers should be between 0 and 1. The first number determines where the palette begins, and the second number where it ends. For sequential palettes, 0 means the leftmost (normally lightest) color, and 1 the rightmost (often darkest) color. For diverging palettes, 0 means the middle color, and 1 both extremes. If only one number is provided, this number is interpreted as the endpoint (with 0 taken as the start). By default, it is set automatically, based on \code{n}.}

\item{include.na}{should color for missing values be shown? \code{FALSE} by default}

\item{show.scores}{should scores of the quality indicators be printed? See details for a description of those indicators.}

\item{columns}{number of columns. By default equal to \code{n} or, if not specified, 12. Cannot be higher than the palette lengths.}

\item{verbose}{should messages and warnings be printed?}
}
\value{
An HMTL table (\code{kableExtra} object)
}
\description{
Graphical user interface to analyse palettes. \code{c4a_table} shows a table that can be opened in the browser. \code{c4a_gui} is a graphical user interface (shiny app) around this table.
}
\examples{
if (requireNamespace("shiny") &&
  requireNamespace("shinyjs") &&
  requireNamespace("kableExtra") &&
  requireNamespace("colorblindcheck") &&
  interactive()) {

c4a_gui()

# categorical palettes with maximum number of colors
c4a_table(type = "cat")

# sort sequential palettes by hue
c4a_table(type = "seq", n = 7, sort = "H")

# sort sequential palettes by hue type (how many hues are used)
c4a_table(type = "seq", n = 5, sort = "hueType")
}
}
\seealso{
References of the palettes: \code{\link{cols4all-package}}.
}
