% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Manhattan.R
\name{Manhattan}
\alias{Manhattan}
\title{Manhattan Numeric Comparator}
\usage{
Manhattan()
}
\value{
A \code{Manhattan} instance is returned, which is an S4 class inheriting
from \code{\link{Minkowski}}.
}
\description{
The Manhattan distance (a.k.a. L-1 distance) between two vectors \eqn{x} and
\eqn{y} is the sum of the absolute differences of their Cartesian
coordinates:
\deqn{\mathrm{Manhattan}(x,y) = \sum_{i = 1}^{n} |x_i - y_i|.}{Manhattan(x,y) = sum_i { |x_i - y_i| }.}
}
\note{
The Manhattan distance is a special case of the \code{\link{Minkowski}}
distance with \eqn{p = 1}.
}
\examples{
## Distance between two vectors
x <- c(0, 1, 0, 1, 0)
y <- seq_len(5)
Manhattan()(x, y)

## Distance between rows (elementwise) of two matrices
comparator <- Manhattan()
x <- matrix(rnorm(25), nrow = 5)
y <- matrix(rnorm(5), nrow = 1)
elementwise(comparator, x, y)

## Distance between rows (pairwise) of two matrices
pairwise(comparator, x, y)

}
\seealso{
Other numeric comparators include \code{\link{Euclidean}}, \code{\link{Minkowski}} and
\code{\link{Chebyshev}}.
}
