\name{questionMarks}
\alias{questionMarks}
\alias{rule}
\alias{transformRule}
\title{ Define a Marking Scheme }
\description{
  These functions are used to specify how the result of a comparison
  between two objects
  should be converted to a numeric mark.
}
\usage{
questionMarks(answerNames, maxMark, ...)

rule(answerName, falseMark, ...)

transformRule(pattern, mark) 
}
\arguments{
  \item{answerNames}{ The names of objects that have been compared. }
  \item{maxMark}{ The maximum mark for the question. }
  \item{answerName}{ The name of one object that has been compared. }
  \item{falseMark}{ How many marks to deduct if the comparison result
    was \code{FALSE}. }
  \item{pattern}{ A regular expression to search for within the
    comparison transformations. }
  \item{mark}{ How many marks to deduct if the regular expression is
    matched. }
  \item{\dots}{ For \code{questionMarks}, zero or more marking rules
    (as generated by the
    the \code{rule()} function); for \code{rule()}, zero or more
    transformation rules (as generated by 
    the \code{transformRule()} function. }
}
\details{
  These functions are used to define a marking scheme.  The
  function \code{markQuestions()} can then be used to apply
  the results to a set of comparisons, as generated by
  \code{compareFiles()}.
}
\value{
  An object of class \code{"questionMarks"}.
}
\examples{
# Check a comparison involving an object called 'IndianMothers'
# Start with a mark of 1 and deduct 1 if the comparison failed
questionMarks("IndianMothers",
              maxMark=1,
              rule("IndianMothers", 1))

# Check comparisons involving several objects
# Start with a mark of 2, for each unsuccessful comparison
# deduct 1 mark, and if a comparison involving the object
# 'class' includes a coercion transformation, deduct 1 mark.
questionMarks(c("id", "age", "edu", "class"),
              maxMark=2,
              rule("id", 1),
              rule("age", 1),
              rule("edu", 1),
              rule("class", 1,
                   transformRule("coerced", 1)))
}
\author{ Paul Murrell }
\seealso{
  \code{\link{markQuestions}} and 
  \code{\link{compareFiles}}
}
\keyword{utilities}
\keyword{logic}
