% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BaselearnerPolynomial}
\alias{BaselearnerPolynomial}
\title{Base-learner factory to make polynomial regression}
\format{\code{\link{S4}} object.}
\description{
\code{BaselearnerPolynomial} creates a polynomial base-learner factory
 object which can be registered within a base-learner list and then used
 for training.
}
\section{Usage}{

\preformatted{
BaselearnerPolynomial$new(data_source, data_target, degree, intercept)
BaselearnerPolynomial$new(data_source, data_target, blearner_type, degree, intercept)
}
}

\section{Arguments}{

\describe{
\item{\code{data_source} [\code{Data} Object]}{
  Data object which contains the source data.
}
\item{\code{data_target} [\code{Data} Object]}{
  Data object which gets the transformed source data.
}
\item{\code{degree} [\code{integer(1)}]}{
  This argument is used for transforming the source data. Each element is
  taken to the power of the \code{degree} argument.
}
\item{\code{intercept} [\code{logical(1)}]}{
  Indicating whether an intercept should be added or not. Default is set to TRUE.
}
}
}

\section{Details}{

  The polynomial base-learner factory takes any matrix which the user wants
  to pass the number of columns indicates how much parameter are estimated.
  Note that the intercept isn't added by default. To get an intercept add a
  column of ones to the source data matrix.

  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classblearnerfactory_1_1_polynomial_blearner_factory.html}.
}

\section{Fields}{

  This class doesn't contain public fields.
}

\section{Methods}{

\describe{
\item{\code{getData()}}{Get the data matrix of the target data which is used
  for modeling.}
\item{\code{transformData(X)}}{Transform a data matrix as defined within the
  factory. The argument has to be a matrix with one column.}
\item{\code{summarizeFactory()}}{Summarize the base-learner factory object.}
}
}

\examples{
# Sample data:
data.mat = cbind(1:10)

# Create new data object:
data.source = InMemoryData$new(data.mat, "my.data.name")
data.target1 = InMemoryData$new()
data.target2 = InMemoryData$new()

# Create new linear base-learner factory:
lin.factory = BaselearnerPolynomial$new(data.source, data.target1, 
  degree = 2, intercept = FALSE)
lin.factory.int = BaselearnerPolynomial$new(data.source, data.target2, 
  degree = 2, intercept = TRUE)

# Get the transformed data:
lin.factory$getData()
lin.factory.int$getData()

# Summarize factory:
lin.factory$summarizeFactory()

# Transform data manually:
lin.factory$transformData(data.mat)
lin.factory.int$transformData(data.mat)

}
