% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LoggerOobRisk}
\alias{LoggerOobRisk}
\title{Logger class to log the out of bag risk}
\format{\code{\link{S4}} object.}
\description{
This class logs the out of bag risk for a specific loss function. It is
also possible to use custom losses to log performance measures. For details
see the use case or extending compboost vignette.
}
\section{Usage}{

\preformatted{
LoggerOobRisk$new(use_as_stopper, used_loss, eps_for_break, oob_data,
  oob_response)
}
}

\section{Arguments}{

\describe{
\item{\code{use_as_stopper} [\code{logical(1)}]}{
  Boolean to indicate if the logger should also be used as stopper.
}
\item{\code{used_loss} [\code{Loss} object]}{
  The loss used to calculate the empirical risk by taking the mean of the
  returned defined loss within the loss object.
}
\item{\code{eps_for_break} [\code{numeric(1)}]}{
  This argument is used if the loss is also used as stopper. If the relative
  improvement of the logged inbag risk falls above this boundary the stopper
  returns \code{TRUE}.
}
\item{\code{oob_data} [\code{list}]}{
  A list which contains data source objects which corresponds to the
  source data of each registered factory. The source data objects should
  contain the out of bag data. This data is then used to calculate the
  prediction in each step.
}
\item{\code{oob_response} [\code{numeric}]}{
  Vector which contains the response for the out of bag data given within
  the \code{list}.
}
}
}

\section{Details}{


This logger computes the risk for a given new dataset
\eqn{\mathcal{D}_\mathrm{oob} = \{(x^{(i)},\ y^{(i)})\ |\ i \in I_\mathrm{oob}\}}
and stores it into a vector. The OOB risk \eqn{\mathcal{R}_\mathrm{oob}} for
iteration \eqn{m} is calculated by:
\deqn{
  \mathcal{R}_\mathrm{oob}^{[m]} = \frac{1}{|\mathcal{D}_\mathrm{oob}|}\sum\limits_{(x,y) \in \mathcal{D}_\mathrm{oob}}
  L(y, \hat{f}^{[m]}(x))
}

\strong{Note:}
  \itemize{

  \item
    If \eqn{m=0} than \eqn{\hat{f}} is just the offset.

  \item
    The implementation to calculate \eqn{\mathcal{R}_\mathrm{emp}^{[m]}} is
    done in two steps:
      \enumerate{

      \item
        Calculate vector \code{risk_temp} of losses for every observation for
        given response \eqn{y^{(i)}} and prediction \eqn{\hat{f}^{[m]}(x^{(i)})}.

      \item
        Average over \code{risk_temp}.
     }
   }

   This procedure ensures, that it is possible to e.g. use the AUC or any
   arbitrary performance measure for risk logging. This gives just one
   value for \eqn{risk_temp} and therefore the average equals the loss
   function. If this is just a value (like for the AUC) then the value is
   returned.

  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classlogger_1_1_oob_risk_logger.html}.
}

\section{Fields}{

  This class doesn't contain public fields.
}

\section{Methods}{

\describe{
\item{\code{summarizeLogger()}}{Summarize the logger object.}
}
}

\examples{
# Define data:
X1 = cbind(1:10)
X2 = cbind(10:1)
data.source1 = InMemoryData$new(X1, "x1")
data.source2 = InMemoryData$new(X2, "x2")

oob.list = list(data.source1, data.source2)

set.seed(123)
y.oob = rnorm(10)

# Used loss:
log.bin = LossBinomial$new()

# Define logger:
log.oob.risk = LoggerOobRisk$new(FALSE, log.bin, 0.05, oob.list, y.oob)

# Summarize logger:
log.oob.risk$summarizeLogger()

}
