% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot.complmrob}
\alias{plot.complmrob}
\title{Diagnostic plots for the robust regression model with compositional covariates}
\usage{
\method{plot}{complmrob}(x, y = NULL, type = c("response", "model"),
  se = TRUE, conf.level = 0.95, scale = c("ilr", "percent"),
  theme = theme_bw(), pointStyle = list(color = "black", size = rel(1),
  alpha = 1, shape = 19), lineStyle = list(color = "grey20", width =
  rel(1), linetype = "solid"), seBandStyle = list(color = "gray80", alpha
  = 0.5), stack = c("horizontal", "vertical"), ...)
}
\arguments{
\item{x}{the object returned by \code{\link{complmrob}}.}

\item{y}{ignored.}

\item{type}{one of \code{"response"} to plot the response or \code{"model"} to get the standard
\code{\link[robustbase]{lmrob}} model diagnostic plots. Partial matching is performed, so any unique
abbreviation of the two possible values is excepted (e.g., \code{"r"} for the response plot).}

\item{se}{should the confidence interval be shown in the response plot.}

\item{conf.level}{if the confidence interval is shown in the response plot, this parameter sets
the level of the confidence interval.}

\item{scale}{should the x-axis in the response plot be in percentage or in the ILR-transformed scale?}

\item{theme}{the ggplot2 theme to use for the response plot.}

\item{pointStyle}{a list with style parameters for the points in the response plot (possible entries
are \code{color}, \code{size}, \code{alpha}, and \code{shape}). If \code{color} and/or \code{shape} is a vector
of length equal to the number of observations in the model, the points will be colored/shaped according
to this vector.}

\item{lineStyle}{list with style parameters for the smoothing lines in the response plot (possible entries
are \code{color}, \code{width}, and \code{linetype})}

\item{seBandStyle}{a list with style parameters (\code{color} and \code{alpha}) for the confidence band (if \code{se} is \code{TRUE})}

\item{stack}{how the facets are laid out in the response plot. \code{"horizontal"} for side by side and \code{"vertical"}
for on top of each other.}

\item{...}{further arguments to the model diagnostic plot method (see \code{\link[robustbase]{plot.lmrob}} for details).}
}
\description{
Plot the response or the model diagnostic plots for robust linear regression model with compositional
data
}
\details{
The response plot shows the value on the first component of the orthonormal basis versus the response
and the fitted values. For the fitted values, the other components are set to the median of the values
in that direction. This usually causes aberrant predictions when plotting on the *percent* scale.

For the model diagnostic plots see the details in the help file for \code{\link[robustbase]{plot.lmrob}}.
The model diagnostic plots are the same for all sub-models fit to the data transformed with the different
orthonormal basis.
}
\examples{
data <- data.frame(lifeExp = state.x77[, "Life Exp"], USArrests[ , -3])
mUSArr <- complmrob(lifeExp ~ ., data = data)
plot(mUSArr)
plot(mUSArr, type = "model") # for the model diagnostic plots
}
