% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_function.R
\name{Simulations}
\alias{Simulations}
\title{Function to simulate compositional time series data}
\usage{
Simulations(N, TT, K, A, B, C, mu, D, outliers_discre, q)
}
\arguments{
\item{N}{The number of categories in the composition}

\item{TT}{The time series length}

\item{K}{The state vector dimension}

\item{A}{The N x K matrix of factor loadings in the observation equation}

\item{B}{The K x K autoregressive matrix of the transition equation}

\item{C}{The K x K matrix determining the magnitude of the persistent outliers}

\item{mu}{The K-dimensional intercept vector in the transition equation}

\item{D}{A K x K matrix determining the variance-covariance matrix of the error term}

\item{outliers_discre}{An R x 3 matrix of discretionary outliers. R denotes the number of discretionary outliers. The first, second and third columns denote the time position, the composite position and the magnitude of the outliers}

\item{q}{Probability of persistent outlier eventuating}
}
\value{
A list with the following components:
\item{\code{datasim}}{A TT x K  data frame with the generated time series compositional data. }
\item{\code{outliers_persist}}{A matrix indicating the time location of the persistant outliers (first column) and the factors (or states) where the outlier eventuates (second column). }
\item{\code{outliers_discre}}{A matrix equivalent to the function argument provided by the user.}
\item{\code{outliers_timeloc}}{A vector with the time location of all the outliers.}
}
\description{
Function to simulate compositional time series data
}
\examples{
set.seed(2000)
N <- 30
K <- 2
TT <- 500
A <- matrix(rnorm(N*K, 0, 0.3), N, K)
B <- matrix(c(0.8,0,0,0.5), K, K)
C <- matrix(c(5,0,0,4), K, K)
mu <- c(0.3, 0.7)
D <- matrix(c(0.4,0,0,0.4), K, K)
outliers_discre <- matrix(c(117, 2, 10, 40, 8, 200), 2, 3, byrow = TRUE)
q <- 0.005
y <-  Simulations(N = N,
                 TT = TT,
                 K = K,
                 A = A,
                 B = B,
                 C = C,
                 mu = mu,
                 D = D,
                 outliers_discre = outliers_discre,
                 q = q)


}
