% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{cs_combine}
\alias{cs_combine}
\title{Ensure Objects Contain Data Only For a Given Year}
\usage{
cs_combine(type = "year", date, ...)
}
\arguments{
\item{type}{"year" is the only valid input currently; year to date functionality
is planned for a later update}

\item{date}{For \code{type = "year"}, this should be the year of data to be returned.
For \code{type = "ytd"}, this should be the last month to be included in each estimate.}

\item{...}{An unquoted list of objects}
}
\value{
A tibble containing a selection of combined crime data for a given time period.
}
\description{
Since crimes are sometimes reported well after they are committed, objects created
    with \code{cs_collapse} often contain crimes that occurred in prior years. The \code{cs_combine}
    function ensures that objects contain only data for a given year, with the ability to add in
    crimes reported for the given year in later years.
}
\details{
When applied to a single year's worth of data, \code{cs_combine} will subset out
    any crimes that occured in a year other than the one given for the \code{date} argument.

    When applied to a range of objects, such as objects for 2017 and 2018, each object will be
    subset to identify crimes that occured in the year given for the \code{date} argument. This
    creates a more complete accounting of crime in a given year since it adds in crimes reported
    in subsequent years to the object. At the same time, crimes that occured prior to the given
    year will also be subset out to ensure the resulting object only contains crimes
    that occured in that given year.
}
\examples{
# load example year-list objects
load(system.file("testdata", "yearList17.rda", package = "compstatr", mustWork = TRUE))
load(system.file("testdata", "yearList18.rda", package = "compstatr", mustWork = TRUE))

# validate
cs_validate(yearList17, year = 2017)
cs_validate(yearList18, year = 2018)

# standaridze May for the 2017 object, which has 26 variables
yearList17 <- cs_standardize(yearList17, month = "May", config = 26)

# validate again to confirm fix
cs_validate(yearList17, year = 2017)

# collapse now that the data are valid
crimeReports17 <- cs_collapse(yearList17)
crimeReports18 <- cs_collapse(yearList18)

# combine to add all sample 2017 crimes reported in 2018 to a single 2017 object
# and remove from our 2017 object all sample crimes reported in 2017 that occured prior
# to that year
crime17 <- cs_combine(type = "year", date = 2017, crimeReports17, crimeReports18)

}
