% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.comstab}
\alias{plot.comstab}
\title{Plotting a \code{comstab} object}
\usage{
\method{plot}{comstab}(x, \dots, xlab = "", ylab = "Log scale", cex.comp = 1)
}
\arguments{
\item{x}{object of class \code{'comstab'}.}

\item{...}{other parameters to be passed through to plotting functions.}

\item{xlab}{a label for the x axis, removed by defaults.}

\item{ylab}{a label for the y axis, defaults to 'Log scale'.}

\item{cex.comp}{A numerical value giving the label size of stabilizing components.
This is an absolute measure, not scaled by par("cex").}
}
\value{
No return value, graphical function.
}
\description{
Plotting method for object inheriting from class "comstab".
}
\examples{
require(graphics)

# Simulates a custom community time series using 'comTS()':
z <- comTS(nsp = 10, ny = 30, even = 0.6, mvs = 1.5, sync = "0")

# Runs the partitioning of the community coefficient of variation:
x <- partitionR(z)

# Plots the result
plot(x)

}
\author{
Jules Segrestin, \email{jsegrestin@gmail.com}
}
