% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csReport.R
\name{csReport}
\alias{csReport}
\title{Report results of conditioning data}
\usage{
csReport(csCompareObj = NULL, csSensitivityObj = NULL, save = FALSE,
  fileName = "report", alphaLevel = 0.05, interpretation = FALSE)
}
\arguments{
\item{csCompareObj}{a list or data frame returned from
the \code{csCompare} function. The object should be of class csCompare.}

\item{csSensitivityObj}{Sensitivity analysis results returned from the
\code{csSensitivity} function.  The object should be of class csSensitivity.}

\item{save}{If \code{code} argument is set to \code{FALSE} (default), the
results are printed on the sceen. Otherwise, a '.txt' file with the
report is generated.}

\item{fileName}{The file name of the produced report. The argument is
ignored if \code{save} is set to \code{FALSE}.}

\item{alphaLevel}{The alpha level to be used for determining significant
or non-significant results.}

\item{interpretation}{Should an interpretation of the results be included?
(FALSE). In case of the Bayesian results, the results
are interpreted according to Lee and Wagenmakers (2013).}
}
\description{
Report results of data analyses run with the \code{csCompare}.
}
\examples{
tmp <- csCompare(cs1 = rnorm(n = 100, mean = 10),
cs2 = rnorm(n = 100, mean = 9))
csReport(tmp)
}

