% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pipeline.R
\name{run_pipeline_gbq}
\alias{run_pipeline_gbq}
\title{A wrapper for running pipelines with a BigQuery invocation query}
\usage{
run_pipeline_gbq(pipeline, query, project, ...)
}
\arguments{
\item{pipeline}{User-provided function with one argument, one row of query results}

\item{query}{A query to execute in Google BigQuery}

\item{project}{The Google BigQuery project to bill}

\item{...}{Additional arguments passed to query_exec()}
}
\description{
A wrapper for running pipelines with a BigQuery invocation query
}
\examples{

\dontrun{
library(whisker)

#Set GBQ project
project <- ''

#Set the following options for GBQ authentication on a cloud instance
options("httr_oauth_cache" = "~/.httr-oauth")
options(httr_oob_default=TRUE)

#Run the below query to authenticate and write credentials to .httr-oauth file
query_exec("SELECT 'foo' as bar",project=project);

pipeline <- function(params){

  query <- "
    SELECT
      {{#list}}
        SUM(CASE WHEN author.name ='{{name}}' THEN 1 ELSE 0 END) as n_{{name_clean}},
      {{/list}}
      repo_name
    FROM `bigquery-public-data.github_repos.sample_commits`
    GROUP BY repo_name
  ;"

  res <- query_exec(
    whisker.render(query,params),
    project=project,
    use_legacy_sql = FALSE
  );

  print(res)
}

run_pipeline_gbq(pipeline, "
  SELECT CONCAT('[',
  STRING_AGG(
    CONCAT('{\\"name\\":\\"',name,'\\",'
      ,'\\"name_clean\\":\\"', REGEXP_REPLACE(name, r'[^[:alpha:]]', ''),'\\"}'
    )
  ),
  ']') as list
  FROM (
    SELECT author.name,
      COUNT(commit) n_commits
    FROM `bigquery-public-data.github_repos.sample_commits`
    GROUP BY 1
    ORDER BY 2 DESC
    LIMIT 10
  )
",
project,
use_legacy_sql = FALSE
)
}
}
